/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.io.PlaceholderDirectory;
import adams.flow.standalone.AbstractStandalone;

public class MakeDir
extends AbstractStandalone {
    private static final long serialVersionUID = -4834816502537753658L;
    protected PlaceholderDirectory m_Directory;

    @Override
    public String globalInfo() {
        return "Creates the user-supplied directory if not already existing. The actor automatically creates all missing directories in the directory hierarchy.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directory", new PlaceholderDirectory("."));
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("directory");
        result = variable != null ? variable : this.getDirectory().toString();
        return result;
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to create, if necessary.";
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            this.debug("Directory '" + this.m_Directory + "' exists: " + this.m_Directory.exists());
            if (!this.m_Directory.exists() && !this.m_Directory.mkdirs()) {
                String string = "Error creating directory '" + this.m_Directory + "'!";
            }
            result = null;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

