/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.template.AbstractActorTemplate;

public class FromFile
extends AbstractActorTemplate {
    private static final long serialVersionUID = -2578720795833851960L;
    protected PlaceholderFile m_TemplateFile;

    @Override
    public String globalInfo() {
        return "Merely loads an actor from a file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "templateFile", new PlaceholderFile("."));
    }

    public void setTemplateFile(PlaceholderFile value) {
        this.m_TemplateFile = value;
        this.reset();
    }

    public PlaceholderFile getTemplateFile() {
        return this.m_TemplateFile;
    }

    public String templateFileTipText() {
        return "The template file to load.";
    }

    @Override
    protected void preGenerate() {
        super.preGenerate();
        String variable = this.getOptionManager().getVariableForProperty("templateFile");
        if (variable == null && !this.m_TemplateFile.isFile()) {
            throw new IllegalStateException("'" + this.m_TemplateFile + "' is not a file!");
        }
    }

    @Override
    protected AbstractActor doGenerate() {
        return ActorUtils.read(this.m_TemplateFile.getAbsolutePath());
    }
}

