/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

public class ArrayToSequence
extends AbstractTransformer {
    private static final long serialVersionUID = 9062714175599800719L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected Vector m_Elements;

    @Override
    public String globalInfo() {
        return "Turns an array of any type into a sequence of tokens.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (Vector)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new Vector();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Elements.get(0));
        this.m_Elements.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Elements.size() > 0;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.clear();
            Object[] array = (Object[])this.m_InputToken.getPayload();
            for (int i = 0; i < array.length; ++i) {
                this.m_Elements.add(array[i]);
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

