/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractPropertyUpdater;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class SetProperty
extends AbstractPropertyUpdater
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 597361990633872666L;
    public static final String BACKUP_INPUT = "input";
    public static final String BACKUP_OUTPUT = "output";
    protected transient Token m_InputToken;
    protected transient Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Sets the property of a global actor whenever a token passes through.\nNote: this actor just sets the value, but performs no re-initialization or similar of the modified object.\nThe transformer just forwards tokens that it receives after the property has been set.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() != null) {
                String value = this.m_InputToken.getPayload().toString();
                this.updateProperty(value);
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    @Override
    public String execute() {
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return super.execute();
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

