/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.Utils;
import adams.flow.transformer.AbstractStringOperation;
import java.util.Vector;

public class StringRangeCut
extends AbstractStringOperation {
    private static final long serialVersionUID = 882143928012626919L;
    protected Type m_Type;
    protected Range m_Range;
    protected String m_Delimiter;
    protected String m_Glue;

    @Override
    public String globalInfo() {
        return "Cuts out a parts of a string. The cut can be either specified as fixed character positions or as fields from delimited columns.\nWhen cutting multiple ranges, a 'glue' for the sub-strings can be provided.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.CHARACTER_POSITIONS);
        this.m_OptionManager.add("range", "range", "1");
        this.m_OptionManager.add("delimiter", "delimiter", "\\t");
        this.m_OptionManager.add("glue", "glue", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Range = new Range();
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of cut operation to perform.";
    }

    public void setRange(String value) {
        this.m_Range.setRange(value);
        this.reset();
    }

    public String getRange() {
        return this.m_Range.getRange();
    }

    public String rangeTipText() {
        return "The range of characters or fields to cut out; " + this.m_Range.getExample();
    }

    public void setDelimiter(String value) {
        this.m_Delimiter = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getDelimiter() {
        return Utils.backQuoteChars(this.m_Delimiter);
    }

    public String delimiterTipText() {
        return "The delimiter to use in case of " + (Object)((Object)Type.DELIMITED_FIELDS) + "; \\t gets " + "automatically converted into its character counterpart.";
    }

    public void setGlue(String value) {
        this.m_Glue = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getGlue() {
        return Utils.backQuoteChars(this.m_Glue);
    }

    public String glueTipText() {
        return "The 'glue' string to use for joining the sub-strings from the ranges; e.g., \\t gets automatically converted into its character counterpart.";
    }

    @Override
    public String getQuickInfo() {
        String variable;
        String result = "";
        if (this.m_Type == Type.CHARACTER_POSITIONS) {
            result = "Chars: ";
            variable = this.getOptionManager().getVariableForProperty("range");
            result = variable != null ? result + variable : result + this.m_Range.getRange();
        } else if (this.m_Type == Type.DELIMITED_FIELDS) {
            result = "Fields: ";
            variable = this.getOptionManager().getVariableForProperty("range");
            result = variable != null ? result + variable : result + this.m_Range;
            result = result + ", Delimiter: ";
            variable = this.getOptionManager().getVariableForProperty("delimiter");
            result = variable != null ? result + variable : result + this.m_Delimiter;
        }
        result = result + ", Glue: ";
        variable = this.getOptionManager().getVariableForProperty("glue");
        result = variable != null ? result + variable : result + this.m_Glue;
        return result;
    }

    @Override
    protected String process(String s) {
        Vector<String> substrings = new Vector<String>();
        if (this.m_Type == Type.CHARACTER_POSITIONS) {
            this.m_Range.setMax(s.length());
            int[][] segs = this.m_Range.getIntSegments();
            for (int i = 0; i < segs.length; ++i) {
                substrings.add(s.substring(segs[i][0], segs[i][1] + 1));
            }
        } else if (this.m_Type == Type.DELIMITED_FIELDS) {
            String[] parts = Utils.split(s, this.m_Delimiter);
            this.m_Range.setMax(parts.length);
            int[] indices = this.m_Range.getIntIndices();
            for (int i = 0; i < indices.length; ++i) {
                substrings.add(parts[indices[i]]);
            }
        } else {
            throw new IllegalStateException("Unhandled cut type: " + (Object)((Object)this.m_Type));
        }
        String result = Utils.flatten(substrings, this.m_Glue);
        return result;
    }

    public static enum Type {
        CHARACTER_POSITIONS,
        DELIMITED_FIELDS;

    }
}

