/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.PrintObject;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.AbstractFrameWithOptionHandling;
import adams.gui.core.GUIHelper;
import javax.swing.JFrame;

public class BaseFrame
extends JFrame {
    private static final long serialVersionUID = -4853427519044621963L;
    protected PrintObject m_SystemOut;
    protected PrintObject m_SystemErr;
    protected PrintObject m_Debugging;

    public BaseFrame() {
        this("");
    }

    public BaseFrame(String title) {
        super(title);
        this.performInitialization();
    }

    protected void performInitialization() {
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
        this.m_SystemOut = new PrintObject(this, PrintObject.OutputType.STDOUT, true, null);
        this.m_SystemErr = new PrintObject(this, PrintObject.OutputType.STDERR, true, null);
        this.m_Debugging = new PrintObject(this, PrintObject.OutputType.DEBUG, false, null);
    }

    protected void initGUI() {
        if (GUIHelper.getLogoIcon() != null) {
            this.setIconImage(GUIHelper.getLogoIcon().getImage());
        }
        this.setDefaultCloseOperation(2);
    }

    protected void finishInit() {
        GUIHelper.setSizeAndLocation(this, this);
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    protected void beforeHide() {
    }

    protected void afterHide() {
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.beforeShow();
        } else {
            this.beforeHide();
        }
        super.setVisible(value);
        if (value) {
            this.afterShow();
        } else {
            this.afterHide();
        }
    }

    public static BaseFrame forName(String classname) {
        BaseFrame result;
        try {
            result = (BaseFrame)OptionUtils.forName(AbstractFrameWithOptionHandling.class, classname, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static BaseFrame runFrame(Class env, Class app) {
        Environment.setEnvironmentClass(env);
        BaseFrame result = BaseFrame.forName(app.getName());
        result.setVisible(true);
        return result;
    }
}

