/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.CustomSearchListModel;
import adams.gui.core.SearchParameters;
import adams.gui.core.SearchableListModel;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class SearchableWrapperListModel
extends AbstractListModel
implements SearchableListModel,
CustomSearchListModel {
    private static final long serialVersionUID = 1379439060928152100L;
    protected ListModel m_Model;
    protected String m_SearchString;
    protected boolean m_RegExpSearch;
    protected Vector<Integer> m_DisplayIndices = null;

    public SearchableWrapperListModel() {
        this(null);
    }

    public SearchableWrapperListModel(ListModel model) {
        this.setActualModel(model);
    }

    public void setActualModel(ListModel value) {
        this.m_Model = value;
        this.initialize();
        this.fireContentsChanged(this, 0, this.m_Model.getSize());
    }

    public ListModel getActualModel() {
        return this.m_Model;
    }

    protected void initialize() {
        if (this.getActualModel() == null) {
            this.m_DisplayIndices = null;
        } else {
            this.m_DisplayIndices = null;
            if (this.m_SearchString != null) {
                this.search(this.m_SearchString, this.m_RegExpSearch);
            }
        }
    }

    protected boolean isInitialized() {
        return this.getActualModel() != null;
    }

    @Override
    public int getActualIndex(int visibleIndex) {
        int result = -1;
        if (this.isInitialized()) {
            result = this.m_DisplayIndices != null ? this.m_DisplayIndices.get(visibleIndex) : visibleIndex;
        }
        return result;
    }

    @Override
    public int getSize() {
        int result = 0;
        if (this.isInitialized()) {
            result = this.m_DisplayIndices == null ? this.getActualModel().getSize() : this.m_DisplayIndices.size();
        }
        return result;
    }

    @Override
    public int getActualSize() {
        return this.getActualModel().getSize();
    }

    @Override
    public boolean isSearchMatch(SearchParameters params, int index) {
        boolean result = false;
        Object value = this.getActualModel().getElementAt(index);
        if (value != null) {
            result = params.matches(value.toString());
        }
        return result;
    }

    @Override
    public synchronized void search(String searchString, boolean regexp) {
        boolean customSearch = this.getActualModel() instanceof CustomSearchListModel;
        this.m_RegExpSearch = regexp;
        this.m_SearchString = searchString;
        SearchParameters params = new SearchParameters(this.m_SearchString, this.m_RegExpSearch);
        if (this.m_SearchString == null) {
            this.m_DisplayIndices = null;
        } else {
            this.m_DisplayIndices = new Vector();
            for (int i = 0; i < this.getActualSize(); ++i) {
                if (customSearch) {
                    if (!((CustomSearchListModel)this.getActualModel()).isSearchMatch(params, i)) continue;
                    this.m_DisplayIndices.add(i);
                    continue;
                }
                if (!this.isSearchMatch(params, i)) continue;
                this.m_DisplayIndices.add(i);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public String getSeachString() {
        return this.m_SearchString;
    }

    @Override
    public boolean isRegExpSearch() {
        return this.m_RegExpSearch;
    }

    public Object getElementAt(int index) {
        Object result = null;
        if (this.isInitialized()) {
            if (this.m_DisplayIndices == null) {
                return this.getActualModel().getElementAt(index);
            }
            return this.getActualModel().getElementAt(this.m_DisplayIndices.get(index));
        }
        return result;
    }
}

