/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.FilenameProposer;
import adams.env.Environment;
import adams.flow.setup.FlowSetup;
import adams.flow.setup.FlowSetupManager;
import adams.gui.application.ChildFrame;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.event.UndoEvent;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.setup.FlowSetupCellEditor;
import adams.gui.flow.setup.FlowSetupTableModel;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FlowControlCenterPanel
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
TableModelListener {
    private static final long serialVersionUID = 4732793588874582421L;
    public static final String FILENAME = "FlowControlCenter.props";
    public static final String SESSION_FILE = "FlowControlCenterSession.props";
    public static final String FILE_EXTENSION = "fcc";
    protected static Properties m_Properties;
    protected FlowControlCenterPanel m_Self;
    protected TitleGenerator m_TitleGenerator;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileNew;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileRevert;
    protected JMenuItem m_MenuItemFileClose;
    protected BaseStatusBar m_StatusBar;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected File m_CurrentFile;
    protected BaseFileChooser m_FileChooser;
    protected FlowSetupManager m_Manager;
    protected FlowSetupTableModel m_TableModelSetups;
    protected BaseTableWithButtons m_TableSetups;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonEditFlow;
    protected JButton m_ButtonStart;
    protected JButton m_ButtonPauseAndResume;
    protected JButton m_ButtonStop;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected GenericObjectEditorDialog m_GOEDialog;
    protected FilenameProposer m_FilenameProposer;

    @Override
    protected void initialize() {
        super.initialize();
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow control center panel");
        }
        this.m_Self = this;
        this.m_Manager = new FlowSetupManager();
        this.m_Manager.setStatusMessageHandler(this);
        this.m_CurrentFile = null;
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Flow Control Center", true);
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.addChoosableFileFilter(new ExtensionFileFilter("Flow control center setups", FILE_EXTENSION));
        this.m_FileChooser.setCurrentDirectory(new File(m_Properties.getString("InitialDir", "%h")));
        this.m_FileChooser.setDefaultExtension(FILE_EXTENSION);
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_FilenameProposer = new FilenameProposer("new", FILE_EXTENSION, m_Properties.getString("InitialDir", "%h"));
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "Center");
        this.m_TableModelSetups = new FlowSetupTableModel(this.m_Manager);
        this.m_TableSetups = new BaseTableWithButtons(this.m_TableModelSetups);
        this.m_TableSetups.setAutoResizeMode(0);
        this.m_TableSetups.setUseDynamicRowHeight(true);
        this.m_TableSetups.getColumnModel().getColumn(5).setCellEditor(new FlowSetupCellEditor(this.m_TableModelSetups));
        this.m_TableSetups.getColumnModel().getColumn(4).setCellEditor(new FlowSetupCellEditor(this.m_TableModelSetups));
        this.m_TableSetups.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FlowControlCenterPanel.this.updateButtons();
            }
        });
        ((BaseTable)this.m_TableSetups.getComponent()).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    FlowControlCenterPanel.this.showTablePopup(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_TableModelSetups.addTableModelListener(this);
        this.m_Manager.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlowControlCenterPanel.this.m_TableModelSetups.fireTableDataChanged();
            }
        });
        panel.add((Component)new BaseScrollPane(this.m_TableSetups), "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.setMnemonic('A');
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.addSetup();
            }
        });
        this.m_ButtonEdit = new JButton("Edit...");
        this.m_ButtonEdit.setMnemonic('E');
        this.m_TableSetups.setDoubleClickButton(this.m_ButtonEdit);
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.editSetup();
            }
        });
        this.m_ButtonEditFlow = new JButton("Edit flow...");
        this.m_ButtonEditFlow.setMnemonic('f');
        this.m_ButtonEditFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.editFlow();
            }
        });
        this.m_ButtonStart = new JButton("Start");
        this.m_ButtonStart.setMnemonic('S');
        this.m_ButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.startSetups();
            }
        });
        this.m_ButtonPauseAndResume = new JButton("Pause");
        this.m_ButtonPauseAndResume.setMnemonic('u');
        this.m_ButtonPauseAndResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.pauseAndResumeSetups();
            }
        });
        this.m_ButtonStop = new JButton("Stop");
        this.m_ButtonStop.setMnemonic('p');
        this.m_ButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.stopSetups();
            }
        });
        this.m_ButtonMoveUp = new JButton("Move up");
        this.m_ButtonMoveUp.setMnemonic('u');
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.moveRows(true);
            }
        });
        this.m_ButtonMoveDown = new JButton("Move down");
        this.m_ButtonMoveDown.setMnemonic('d');
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.moveRows(false);
            }
        });
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.setMnemonic('R');
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.removeSetups();
            }
        });
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.setMnemonic('m');
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.removeAllSetups();
            }
        });
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonAdd);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonEdit);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonEditFlow);
        this.m_TableSetups.addToButtonsPanel(new JLabel(""));
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonStart);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonPauseAndResume);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonStop);
        this.m_TableSetups.addToButtonsPanel(new JLabel(""));
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonMoveUp);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonMoveDown);
        this.m_TableSetups.addToButtonsPanel(new JLabel(""));
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonRemove);
        this.m_TableSetups.addToButtonsPanel(this.m_ButtonRemoveAll);
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
        this.m_StatusBar.setMouseListenerActive(true);
        this.m_StatusBar.setStatusProcessor(new BaseStatusBar.StatusProcessor(){

            @Override
            public String process(String msg) {
                return msg.replace(": ", ":\n");
            }
        });
        this.update();
    }

    protected void showTablePopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem(this.m_ButtonEdit.getText());
        menuitem.setEnabled(this.m_ButtonEdit.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("properties.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.editSetup();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonEditFlow.getText());
        menuitem.setEnabled(this.m_ButtonEdit.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("flow.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.editFlow();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonStart.getText());
        menuitem.setEnabled(this.m_ButtonStart.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("run.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.startSetups();
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonPauseAndResume.getText());
        menuitem.setEnabled(this.m_ButtonPauseAndResume.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("pause.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.pauseAndResumeSetups();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonStop.getText());
        menuitem.setEnabled(this.m_ButtonStop.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("stop.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.stopSetups();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonRemove.getText());
        menuitem.setEnabled(this.m_ButtonRemove.isEnabled());
        menuitem.setIcon(GUIHelper.getIcon("delete.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.removeSetups();
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ButtonRemoveAll.getText());
        menuitem.setEnabled(this.m_ButtonRemoveAll.isEnabled());
        menuitem.setIcon(GUIHelper.getEmptyIcon());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowControlCenterPanel.this.removeAllSetups();
            }
        });
        menu.add(menuitem);
        menu.show(this, e.getX(), e.getY());
    }

    protected void addSetup() {
        this.getGOEDialog().getEditor().setValue(new FlowSetup());
        this.getGOEDialog().setLocationRelativeTo(this);
        this.getGOEDialog().setVisible(true);
        if (this.getGOEDialog().getResult() == 0) {
            this.m_TableModelSetups.addSetup((FlowSetup)this.getGOEDialog().getCurrent());
            this.m_TableSetups.setOptimalColumnWidth();
            this.update();
        }
    }

    protected void editSetup() {
        this.getGOEDialog().getEditor().setValue(this.m_TableModelSetups.getSetup(this.m_TableSetups.getSelectedRow()).shallowCopy());
        this.getGOEDialog().setLocationRelativeTo(this);
        this.getGOEDialog().setVisible(true);
        if (this.getGOEDialog().getResult() == 0) {
            this.m_TableModelSetups.setSetup(this.m_TableSetups.getSelectedRow(), (FlowSetup)this.getGOEDialog().getCurrent());
            this.m_TableSetups.setOptimalColumnWidth();
            this.update();
        }
    }

    protected void editFlow() {
        FlowSetup setup = this.m_TableModelSetups.getSetup(this.m_TableSetups.getSelectedRow());
        BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(this.getParentFrame(), true);
        FlowEditorPanel panel = new FlowEditorPanel();
        String classname = FlowEditorPanel.getProperties().getString("FlowEditorClass", FlowEditorPanel.class.getName());
        try {
            panel = (FlowEditorPanel)Class.forName(classname).newInstance();
        }
        catch (Exception ex) {
            panel = new FlowEditorPanel();
        }
        panel.loadUnsafe(setup.getFile());
        dialog.setTitle("Flow editor");
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setJMenuBar(panel.getMenuBar());
        dialog.setSize(640, 480);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    protected void startSetups() {
        int[] indices = this.m_TableSetups.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            try {
                if (this.m_TableModelSetups.getSetup(indices[i]).execute()) continue;
                GUIHelper.showErrorMessage(this, "Error executing flow '" + this.m_TableModelSetups.getSetup(indices[i]).getName() + "':\n" + this.m_TableModelSetups.getSetup(indices[i]).retrieveLastError(), "Flow execution error");
                continue;
            }
            catch (Exception ex) {
                GUIHelper.showErrorMessage(this, "Error executing flow '" + this.m_TableModelSetups.getSetup(indices[i]).getName() + "':\n" + ex.toString(), "Flow execution error");
            }
        }
        this.update();
    }

    protected void pauseAndResumeSetups() {
        int[] indices = this.m_TableSetups.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            FlowSetup setup = this.m_TableModelSetups.getSetup(indices[i]);
            if (setup.isPaused()) {
                setup.resumeExecution();
                continue;
            }
            setup.pauseExecution();
        }
        this.update();
    }

    protected void stopSetups() {
        int[] indices = this.m_TableSetups.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            this.m_TableModelSetups.getSetup(indices[i]).stopExecution();
        }
        this.update();
    }

    protected void moveRows(boolean up) {
        int[] indices = up ? this.m_TableModelSetups.moveUp(this.m_TableSetups.getSelectedRows()) : this.m_TableModelSetups.moveDown(this.m_TableSetups.getSelectedRows());
        ListSelectionModel selModel = this.m_TableSetups.getSelectionModel();
        selModel.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            selModel.addSelectionInterval(indices[i], indices[i]);
        }
    }

    protected void removeSetups() {
        int[] indices = this.m_TableSetups.getSelectedRows();
        ListSelectionModel selModel = this.m_TableSetups.getSelectionModel();
        selModel.clearSelection();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_TableModelSetups.removeSetup(indices[i]);
        }
        this.m_TableSetups.setOptimalColumnWidth();
        this.update();
    }

    protected void removeAllSetups() {
        ListSelectionModel selModel = this.m_TableSetups.getSelectionModel();
        selModel.clearSelection();
        this.m_TableModelSetups.clearSetups();
        this.m_TableSetups.setOptimalColumnWidth();
        this.update();
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowControlCenterPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowControlCenterPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowControlCenterPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("New");
            menu.add(menuitem);
            menuitem.setMnemonic('N');
            menuitem.setIcon(GUIHelper.getIcon("new.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.reset();
                }
            });
            this.m_MenuItemFileNew = menuitem;
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, m_Properties.getInteger("MaxRecentFlows", 5), submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                @Override
                public void recentFileAdded(RecentFileEvent e) {
                }

                @Override
                public void recentFileSelected(RecentFileEvent e) {
                    if (!FlowControlCenterPanel.this.checkForModified()) {
                        return;
                    }
                    FlowControlCenterPanel.this.load(e.getFile());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Save");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.save();
                }
            });
            this.m_MenuItemFileSave = menuitem;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Revert");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.revert();
                }
            });
            this.m_MenuItemFileRevert = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowControlCenterPanel.this.close();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            if (GUIHelper.getParent(this.m_Self, ChildFrame.class) != null) {
                menu = new JMenu("Window");
                result.add(menu);
                menu.setMnemonic('W');
                menu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FlowControlCenterPanel.this.updateMenu();
                    }
                });
                menuitem = new JMenuItem("New Window");
                menu.add(menuitem);
                menuitem.setMnemonic('w');
                menuitem.setIcon(GUIHelper.getIcon("new.gif"));
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(FlowControlCenterPanel.this.m_Self, ChildFrame.class);
                        ChildFrame newFrame = oldFrame.getNewWindow();
                        newFrame.setVisible(true);
                    }
                });
            }
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected GenericObjectEditorDialog getGOEDialog() {
        if (this.m_GOEDialog == null) {
            this.m_GOEDialog = GenericObjectEditorDialog.createDialog(this);
            this.m_GOEDialog.setTitle("Flow setup");
            this.m_GOEDialog.getGOEEditor().setClassType(FlowSetup.class);
            this.m_GOEDialog.getGOEEditor().setValue(new FlowSetup());
        }
        return this.m_GOEDialog;
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void undoOccurred(UndoEvent e) {
        this.updateMenu();
    }

    protected void update() {
        this.updateMenu();
        this.updateButtons();
    }

    protected void updateTitle() {
        this.setParentTitle(this.m_TitleGenerator.generate(this.m_CurrentFile, this.m_Manager.isModified()));
    }

    protected void updateButtons() {
        int selRowCount = this.m_TableSetups.getSelectedRowCount();
        FlowSetup setup = selRowCount == 1 ? this.m_TableModelSetups.getSetup(this.m_TableSetups.getSelectedRow()) : null;
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonEdit.setEnabled(selRowCount == 1 && setup != null && !setup.isRunning());
        this.m_ButtonEditFlow.setEnabled(selRowCount == 1 && setup != null && !setup.isRunning());
        if (selRowCount > 1) {
            this.m_ButtonStart.setEnabled(true);
            this.m_ButtonPauseAndResume.setEnabled(true);
            this.m_ButtonStop.setEnabled(true);
        } else if (selRowCount == 1) {
            this.m_ButtonStart.setEnabled(!setup.isRunning());
            this.m_ButtonPauseAndResume.setEnabled(setup.isRunning());
            this.m_ButtonStop.setEnabled(setup.isRunning());
        } else {
            this.m_ButtonStart.setEnabled(false);
            this.m_ButtonPauseAndResume.setEnabled(false);
            this.m_ButtonStop.setEnabled(false);
        }
        if (setup != null && setup.isPaused()) {
            this.m_ButtonPauseAndResume.setText("Resume");
        } else {
            this.m_ButtonPauseAndResume.setText("Pause");
        }
        this.m_ButtonMoveUp.setEnabled(this.m_TableModelSetups.canMoveUp(this.m_TableSetups.getSelectedRows()));
        this.m_ButtonMoveDown.setEnabled(this.m_TableModelSetups.canMoveDown(this.m_TableSetups.getSelectedRows()));
        this.m_ButtonRemove.setEnabled(selRowCount > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_TableSetups.getRowCount() > 0);
    }

    protected void updateMenu() {
        this.updateTitle();
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileRevert.setEnabled(this.m_Manager.isModified());
        this.m_MenuItemFileSave.setEnabled(this.m_Manager.isModified());
    }

    protected boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.m_Manager.isModified();
        if (!result) {
            String msg = this.m_CurrentFile == null ? "Setup not saved - save?" : "Setup '" + this.m_CurrentFile + "' not saved - save?";
            int retVal = JOptionPane.showConfirmDialog(this, msg, "Setup not saved", 1);
            switch (retVal) {
                case 0: {
                    if (this.m_CurrentFile != null) {
                        this.save();
                    } else {
                        this.saveAs();
                    }
                    result = !this.m_Manager.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void cleanUp() {
        for (int i = 0; i < this.m_Manager.size(); ++i) {
            ((FlowSetup)this.m_Manager.get(i)).stopExecution();
            ((FlowSetup)this.m_Manager.get(i)).cleanUp();
        }
    }

    protected void reset() {
        if (!this.checkForModified()) {
            return;
        }
        this.cleanUp();
        this.m_CurrentFile = null;
        this.m_TableSetups.getSelectionModel().clearSelection();
        this.m_TableModelSetups.clearSetups();
        this.m_TableSetups.setOptimalColumnWidth();
        this.m_Manager.setModified(false);
        this.update();
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void load(File file) {
        this.cleanUp();
        this.m_TableSetups.getSelectionModel().clearSelection();
        this.showStatus("Loading '" + file + "'...");
        this.m_Manager.read(file.getAbsolutePath());
        this.m_TableModelSetups.fireTableDataChanged();
        this.showStatus("");
        this.m_CurrentFile = file;
        this.m_FileChooser.setCurrentDirectory(file.getParentFile());
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentFile(file);
        }
        this.m_TableSetups.setOptimalColumnWidth();
        this.update();
    }

    protected void open() {
        if (!this.checkForModified()) {
            return;
        }
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.load(this.m_FileChooser.getSelectedPlaceholderFile());
    }

    protected void revert() {
        if (!this.checkForModified()) {
            return;
        }
        this.load(this.m_CurrentFile);
    }

    protected void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
            return;
        }
        final File currFile = this.m_CurrentFile;
        SwingWorker worker = new SwingWorker(){
            boolean m_Result;

            protected Object doInBackground() throws Exception {
                FlowControlCenterPanel.this.showStatus("Saving '" + currFile + "'...");
                this.m_Result = FlowControlCenterPanel.this.m_Manager.write(currFile.getAbsolutePath());
                FlowControlCenterPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                if (!this.m_Result) {
                    GUIHelper.showErrorMessage(FlowControlCenterPanel.this.m_Self, "Error saving setup to '" + currFile.getAbsolutePath() + "'!");
                } else if (FlowControlCenterPanel.this.m_RecentFilesHandler != null) {
                    FlowControlCenterPanel.this.m_RecentFilesHandler.addRecentFile(currFile);
                }
                FlowControlCenterPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    protected void saveAs() {
        this.m_FileChooser.setSelectedFile(this.m_FilenameProposer.propose(this.m_CurrentFile));
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        this.m_CurrentFile = this.m_FileChooser.getSelectedPlaceholderFile();
        this.save();
    }

    protected void close() {
        if (!this.checkForModified()) {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(true);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(true);
            }
            return;
        }
        this.cleanUp();
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    protected void showMessage(String msg) {
        String status = msg.replaceAll(": ", ":\n");
        GUIHelper.showInformationMessage(this, status, "Status");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.update();
    }
}

