/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.setup;

import adams.event.FlowSetupStateEvent;
import adams.event.FlowSetupStateListener;
import adams.flow.setup.FlowSetup;
import adams.flow.setup.FlowSetupManager;
import adams.gui.core.AbstractMoveableTableModel;

public class FlowSetupTableModel
extends AbstractMoveableTableModel
implements FlowSetupStateListener {
    private static final long serialVersionUID = 3035229549624468704L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DESC = 1;
    public static final int COLUMN_HEADLESS = 2;
    public static final int COLUMN_RUNNING = 3;
    public static final int COLUMN_ONFINISH = 4;
    public static final int COLUMN_ONERROR = 5;
    public static final int COLUMN_ERROR = 6;
    protected FlowSetupManager m_Manager;

    public FlowSetupTableModel(FlowSetupManager manager) {
        this.m_Manager = manager;
        for (int i = 0; i < this.m_Manager.size(); ++i) {
            ((FlowSetup)this.m_Manager.get(i)).addFlowSetupStateChangeListener(this);
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Description/File";
        }
        if (column == 2) {
            return "Headless";
        }
        if (column == 3) {
            return "Running";
        }
        if (column == 4) {
            return "OnFinish";
        }
        if (column == 5) {
            return "OnError";
        }
        if (column == 6) {
            return "Error";
        }
        throw new IllegalArgumentException("Invalid column index: " + column);
    }

    @Override
    public int getRowCount() {
        return this.m_Manager.size();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return Boolean.class;
        }
        if (columnIndex == 3) {
            return Boolean.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        if (columnIndex == 5) {
            return String.class;
        }
        if (columnIndex == 6) {
            return String.class;
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = false;
        if (rowIndex < 0 || rowIndex >= this.m_Manager.size()) {
            return result;
        }
        FlowSetup setup = (FlowSetup)this.m_Manager.get(rowIndex);
        if (setup.isRunning()) {
            if (columnIndex == 3) {
                result = true;
            }
        } else if (columnIndex == 2) {
            result = true;
        } else if (columnIndex == 3) {
            result = true;
        } else if (columnIndex == 4) {
            result = true;
        } else if (columnIndex == 5) {
            result = true;
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (rowIndex < 0 || rowIndex >= this.m_Manager.size()) {
            return null;
        }
        FlowSetup setup = (FlowSetup)this.m_Manager.get(rowIndex);
        if (columnIndex == 0) {
            result = setup.getName();
        } else if (columnIndex == 1) {
            result = "<html>" + (setup.getDescription().length() > 0 ? setup.getDescription() + "<br>" : "") + "<font color='blue' size='-2'>" + setup.getFile().getPath() + "</font>" + "</html>";
        } else if (columnIndex == 2) {
            result = setup.isHeadless();
        } else if (columnIndex == 3) {
            result = setup.isRunning();
        } else if (columnIndex == 4) {
            result = setup.getOnFinish();
        } else if (columnIndex == 5) {
            result = setup.getOnError();
        } else if (columnIndex == 6) {
            result = setup.retrieveLastError();
        } else {
            throw new IllegalArgumentException("Invalid column index: " + columnIndex);
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        FlowSetup setup = this.getSetup(rowIndex);
        if (columnIndex == 2) {
            this.m_Manager.setModified(true);
            setup.setHeadless((Boolean)value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 3) {
            if (!setup.isRunning()) {
                setup.execute();
            } else {
                setup.stopExecution();
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 4) {
            this.m_Manager.setModified(true);
            setup.setOnFinish((String)value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 5) {
            this.m_Manager.setModified(true);
            setup.setOnError((String)value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public int indexOf(FlowSetup setup) {
        int result = -1;
        for (int i = 0; i < this.m_Manager.size(); ++i) {
            if (!((FlowSetup)this.m_Manager.get(i)).equals(setup)) continue;
            result = i;
            break;
        }
        return result;
    }

    public FlowSetup getSetup(int row) {
        return (FlowSetup)this.m_Manager.get(row);
    }

    public void setSetup(int row, FlowSetup setup) {
        this.m_Manager.set(row, setup);
        this.fireTableRowsUpdated(row, row);
    }

    public void addSetup(FlowSetup setup) {
        this.m_Manager.add(setup.shallowCopy());
        this.fireTableRowsInserted(this.m_Manager.size() - 1, this.m_Manager.size() - 1);
    }

    public void insertSetup(int row, FlowSetup setup) {
        this.m_Manager.add(row, setup.shallowCopy());
        this.fireTableRowsInserted(row, row);
    }

    public void removeSetup(int row) {
        this.m_Manager.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void clearSetups() {
        this.m_Manager.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void flowSetupStateChanged(FlowSetupStateEvent e) {
        int row = this.indexOf(e.getFlowSetup());
        if (row > -1) {
            this.fireTableRowsUpdated(row, row);
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    protected void swap(int firstIndex, int secondIndex) {
        FlowSetup firstSetup = this.getSetup(firstIndex);
        FlowSetup secondSetup = this.getSetup(secondIndex);
        this.setSetup(secondIndex, firstSetup);
        this.setSetup(firstIndex, secondSetup);
    }
}

