/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.goe.AbstractBasicTypePropertyEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class BooleanEditor
extends AbstractBasicTypePropertyEditor {
    protected Boolean m_Current = false;

    @Override
    protected JComponent createCustomEditor() {
        JCheckBox result = new JCheckBox();
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox)e.getSource();
                if (!BooleanEditor.this.getValue().equals(checkbox.isSelected())) {
                    BooleanEditor.this.setValue(checkbox.isSelected());
                }
            }
        });
        return result;
    }

    @Override
    public void setValue(Object value) {
        this.m_Current = new Boolean((Boolean)value);
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_Current;
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        Boolean result;
        try {
            if (text.length() == 0) {
                text = "false";
            }
            result = new Boolean(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    protected void initForDisplay() {
        if (!this.m_Current.equals(((JCheckBox)this.m_CustomEditor).isSelected())) {
            ((JCheckBox)this.m_CustomEditor).setSelected(this.m_Current);
        }
    }
}

