/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.Favorites;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.GenericObjectEditorPopupMenu;
import adams.gui.goe.PropertySheetPanel;
import adams.gui.goe.VariableSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PropertyPanel
extends BasePanel {
    private static final long serialVersionUID = 5370025273466728904L;
    public static final String METHOD_CUSTOMPANEL = "getCustomPanel";
    protected PropertyEditor m_Editor;
    protected GenericObjectEditorDialog m_Dialog;
    protected boolean m_HasCustomPanel;
    protected JButton m_ButtonProperties;
    protected PropertyPanel m_Self;
    protected BasePanel m_PanelText;
    protected JPanel m_PanelCustom;

    public PropertyPanel(PropertyEditor pe) {
        this(pe, false);
    }

    public PropertyPanel(PropertyEditor pe, boolean ignoreCustomPanel) {
        this.m_Editor = pe;
        this.m_HasCustomPanel = !ignoreCustomPanel && this.isCustomPanelSupplier(this.m_Editor);
        this.m_PanelCustom = null;
        this.m_PanelText = null;
        this.initGUI();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_HasCustomPanel = false;
        this.m_Self = this;
    }

    @Override
    protected void initGUI() {
        if (this.m_Editor == null) {
            return;
        }
        if (this.m_HasCustomPanel) {
            this.setLayout(new BorderLayout());
            AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(this.m_Editor);
            this.m_PanelCustom = handler.getCustomPanel(this.m_Editor);
            this.add((Component)this.m_PanelCustom, "Center");
        } else {
            this.createDefaultPanel();
        }
    }

    protected void createDefaultPanel() {
        this.setLayout(new BorderLayout());
        this.m_PanelText = new BasePanel(){
            private static final long serialVersionUID = 6257101099036104231L;

            @Override
            public void paintComponent(Graphics g) {
                if (!PropertyPanel.this.m_HasCustomPanel) {
                    Insets i = this.getInsets();
                    Rectangle box = new Rectangle(i.left, i.top, this.getSize().width - i.left - i.right - 1, this.getSize().height - i.top - i.bottom - 1);
                    g.clearRect(i.left, i.top, this.getSize().width - i.right - i.left, this.getSize().height - i.bottom - i.top);
                    PropertyPanel.this.m_Editor.paintValue(g, box);
                }
            }
        };
        this.m_PanelText.setBorder(BorderFactory.createEtchedBorder());
        this.m_PanelText.setToolTipText("Left-click to edit properties for this object, right-click/Alt+Shift+left-click for menu");
        this.m_PanelText.setOpaque(true);
        this.add((Component)this.m_PanelText, "Center");
        this.m_PanelText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MouseUtils.isLeftClick(evt)) {
                    evt.consume();
                    PropertyPanel.this.showPropertyDialog();
                } else if (MouseUtils.isRightClick(evt)) {
                    evt.consume();
                    GenericObjectEditorPopupMenu menu = new GenericObjectEditorPopupMenu(PropertyPanel.this.m_Editor, PropertyPanel.this.m_Self);
                    JMenuItem item = new JMenuItem("Edit...", GUIHelper.getIcon("properties.gif"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertyPanel.this.showPropertyDialog();
                        }
                    });
                    menu.insert(new JPopupMenu.Separator(), 0);
                    menu.insert(item, 0);
                    PropertySheetPanel parent = VariableSupport.findParent(PropertyPanel.this);
                    if (parent != null) {
                        VariableSupport.updatePopup(parent, PropertyPanel.this.m_Editor, menu);
                    }
                    if (PropertyPanel.this.m_Editor instanceof GenericObjectEditor) {
                        menu.addSeparator();
                        Favorites.getSingleton().customizePopupMenu(menu, ((GenericObjectEditor)PropertyPanel.this.m_Editor).getClassType(), PropertyPanel.this.m_Editor.getValue(), new Favorites.FavoriteSelectionListener(){

                            @Override
                            public void favoriteSelected(Favorites.FavoriteSelectionEvent e) {
                                PropertyPanel.this.m_Editor.setValue(e.getFavorite().getObject());
                            }
                        });
                    }
                    if (PropertyPanel.this.m_Editor instanceof PopupMenuCustomizer) {
                        ((PopupMenuCustomizer)((Object)PropertyPanel.this.m_Editor)).customizePopup(PropertyPanel.this, menu);
                    }
                    menu.show(PropertyPanel.this.m_Self, evt.getX(), evt.getY());
                }
            }
        });
        Dimension newPref = this.getPreferredSize();
        newPref.height = this.getFontMetrics(this.getFont()).getHeight() * 5 / 4;
        newPref.width = newPref.height * 5;
        this.setPreferredSize(newPref);
        this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyPanel.this.repaint();
            }
        });
        this.m_ButtonProperties = new JButton("...");
        this.m_ButtonProperties.setToolTipText("Click to edit properties");
        this.m_ButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.showPropertyDialog();
            }
        });
        this.add((Component)this.m_ButtonProperties, "East");
    }

    public void showPropertyDialog() {
        if (this.m_Editor.getValue() != null) {
            if (this.m_Dialog == null) {
                this.m_Dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
                GUIHelper.setSizeAndLocation(this.m_Dialog, this.getLocationOnScreen().y, this.getLocationOnScreen().x);
                this.m_Dialog.setVisible(true);
            } else {
                this.m_Dialog.setVisible(true);
            }
            this.m_Editor.setValue(this.m_Editor.getValue());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.m_Dialog != null) {
            this.m_Dialog.dispose();
            this.m_Dialog = null;
        }
    }

    public boolean isCustomPanelSupplier(PropertyEditor editor) {
        AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(editor);
        return handler.hasCustomPanel(editor);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        JPanel panel = null;
        panel = this.m_HasCustomPanel ? this.m_PanelCustom : this.m_PanelText;
        if (panel != null) {
            panel.setToolTipText(text);
        }
    }

    public static interface PopupMenuCustomizer {
        public void customizePopup(PropertyPanel var1, JPopupMenu var2);
    }
}

