/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.data.container.DataContainer;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.scripting.AbstractDataContainerUpdatingPostProcessor;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.util.HashSet;
import java.util.Vector;

public abstract class AbstractDataContainerUpdatingScriptlet
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -623707457032656271L;
    protected AbstractDataContainerUpdatingPostProcessor m_PostProcessor;

    @Override
    protected void initialize() {
        super.initialize();
        if (this.hasOwner()) {
            this.m_PostProcessor = this.getOwner().getDataContainerUpdatingPostProcessor();
        }
    }

    protected void updateDataContainers(Vector<DataContainer> conts, boolean overlay) {
        this.updateDataContainers(conts, overlay, new HashSet<Integer>());
    }

    protected void updateDataContainers(Vector<? extends DataContainer> conts, boolean overlay, HashSet<Integer> exclude) {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        boolean[] visible = new boolean[((ContainerManager)manager).count()];
        for (i = 0; i < visible.length; ++i) {
            visible[i] = ((VisibilityContainerManager)manager).isVisible(i);
        }
        Vector data = new Vector();
        int n = 0;
        for (i = 0; i < visible.length; ++i) {
            if (!visible[i]) {
                data.add(((ContainerManager)manager).get(i));
                ((VisibilityContainer)data.lastElement()).setVisible(false);
                continue;
            }
            if (overlay) {
                data.add(((ContainerManager)manager).get(i));
                ((VisibilityContainer)data.lastElement()).setVisible(true);
            }
            ++n;
        }
        n = 0;
        for (i = 0; i < visible.length; ++i) {
            if (!visible[i] || exclude.contains(i)) continue;
            data.add(((ContainerManager)manager).newContainer(conts.get(n)));
            ++n;
        }
        ((ContainerManager)manager).startUpdate();
        ((ContainerManager)manager).clear();
        ((ContainerManager)manager).addAll(data);
        ((ContainerManager)manager).finishUpdate();
        if (this.m_PostProcessor != null) {
            this.m_PostProcessor.postProcess(conts);
        }
    }
}

