/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.db.LogEntry;
import adams.db.LogEntryHandler;
import adams.env.Environment;
import adams.gui.dialog.TextDialog;
import adams.gui.tools.AbstractLogEntryViewerPanel;
import java.util.List;

public class LogEntryViewerPanel
extends AbstractLogEntryViewerPanel {
    private static final long serialVersionUID = -6159575511977628201L;
    public static final String FILENAME = "LogEntryViewer.props";
    protected static Properties m_Properties;

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = LogEntryViewerPanel.getProperties();
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 250));
    }

    @Override
    protected TextDialog createDetailsDialog() {
        TextDialog result = super.createDetailsDialog();
        Properties props = LogEntryViewerPanel.getProperties();
        result.setSize(props.getInteger("DetailsDialog.Width", 400), props.getInteger("DetailsDialog.Height", 300));
        return result;
    }

    public void display(List<LogEntry> entries) {
        this.m_TableModelEntries.clear();
        this.m_TableModelEntries.addAll(entries);
        this.m_TableEntries.setOptimalColumnWidth();
    }

    public void display(LogEntryHandler handler) {
        this.display(handler.getLogEntries());
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("log entry viewer panel");
        }
        return m_Properties;
    }
}

