/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Formatter
implements Serializable {
    private static final long serialVersionUID = 2565690777491622761L;
    public static final String NAN = "NaN";
    protected Format m_Format;

    public Formatter(Format format) {
        this.setFormat(format);
    }

    public void setFormat(Format format) {
        if (format instanceof DecimalFormat) {
            this.m_Format = format;
        } else if (format instanceof SimpleDateFormat) {
            this.m_Format = format;
        } else {
            throw new IllegalArgumentException("Formatters of type " + format.getClass().getName() + " are not allowed!");
        }
    }

    public Format getFormat() {
        return this.m_Format;
    }

    public void applyPattern(String pattern) {
        if (this.m_Format instanceof DecimalFormat) {
            ((DecimalFormat)this.m_Format).applyPattern(pattern);
        } else if (this.m_Format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)this.m_Format).applyPattern(pattern);
        } else {
            throw new IllegalArgumentException("Formatters of type " + this.m_Format.getClass().getName() + " are not supported!");
        }
    }

    public String toPattern() {
        if (this.m_Format instanceof DecimalFormat) {
            return ((DecimalFormat)this.m_Format).toPattern();
        }
        if (this.m_Format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.m_Format).toPattern();
        }
        throw new IllegalArgumentException("Formatters of type " + this.m_Format.getClass().getName() + " are not supported!");
    }

    public Double parse(String s) {
        Double result;
        block6: {
            if (s.equals(NAN)) {
                result = Double.NaN;
            } else {
                try {
                    if (this.m_Format instanceof DecimalFormat) {
                        result = (Double)((DecimalFormat)this.m_Format).parse(s);
                        break block6;
                    }
                    if (this.m_Format instanceof SimpleDateFormat) {
                        result = new Double(((SimpleDateFormat)this.m_Format).parse(s).getTime());
                        break block6;
                    }
                    throw new IllegalArgumentException("Formatters of type " + this.m_Format.getClass().getName() + " are not supported!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = Double.NaN;
                }
            }
        }
        return result;
    }

    public String format(Double value) {
        String result;
        block6: {
            if (Double.isNaN(value)) {
                result = NAN;
            } else {
                try {
                    if (this.m_Format instanceof DecimalFormat) {
                        result = ((DecimalFormat)this.m_Format).format(value);
                        break block6;
                    }
                    if (this.m_Format instanceof SimpleDateFormat) {
                        result = ((SimpleDateFormat)this.m_Format).format(new Date(value.longValue()));
                        break block6;
                    }
                    throw new IllegalArgumentException("Formatters of type " + this.m_Format.getClass().getName() + " are not supported!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = NAN;
                }
            }
        }
        return result;
    }

    protected static Formatter getFormatter(Format format, String pattern) {
        Formatter result = new Formatter(format);
        if (pattern != null) {
            result.applyPattern(pattern);
        }
        return result;
    }

    public String toString() {
        return this.m_Format.getClass().getName() + "/" + this.toPattern();
    }

    public static Formatter getDecimalFormatter() {
        return Formatter.getFormatter(new DecimalFormat(), null);
    }

    public static Formatter getDecimalFormatter(String pattern) {
        return Formatter.getFormatter(new DecimalFormat(), pattern);
    }

    public static Formatter getDateFormatter() {
        return Formatter.getFormatter(new SimpleDateFormat(), null);
    }

    public static Formatter getDateFormatter(String pattern) {
        return Formatter.getFormatter(new SimpleDateFormat(), pattern);
    }
}

