/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.plot;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.visualization.core.plot.AbstractHitDetector;
import java.awt.geom.Point2D;

@MixedCopyright(copyright="2008 Pieter Iserbyt <pieter.iserbyt@gmail.com>", license=License.GPL3, url="http://local.wasp.uwa.edu.au/~pbourke/geometry/pointline/DistancePoint.java", note="Distance calcuation between point and line")
public abstract class AbstractDistanceBasedHitDetector
extends AbstractHitDetector {
    private static final long serialVersionUID = -5861816297859396332L;
    protected int m_MinimumPixelDifference = 2;

    public void setMinimumPixelDifference(int value) {
        if (value >= 0) {
            this.m_MinimumPixelDifference = value;
        } else {
            System.err.println(this.getClass().getName() + ": minimum pixel different must be >= 0!");
        }
    }

    public int getMinimumPixelDifference() {
        return this.m_MinimumPixelDifference;
    }

    protected double distance(Point2D p1, Point2D p2, Point2D p3) {
        double xDelta = p2.getX() - p1.getX();
        double yDelta = p2.getY() - p1.getY();
        if (this.getDebug()) {
            this.getDebugging().println("p1=" + p1 + ", p2=" + p2 + ", p3=" + p3);
        }
        if (xDelta == 0.0 && yDelta == 0.0) {
            return p1.distance(p3);
        }
        double u = ((p3.getX() - p1.getX()) * xDelta + (p3.getY() - p1.getY()) * yDelta) / (xDelta * xDelta + yDelta * yDelta);
        Point2D closestPoint = u < 0.0 ? p1 : (u > 1.0 ? p2 : new Point2D.Double(p1.getX() + u * xDelta, p1.getY() + u * yDelta));
        return closestPoint.distance(p3);
    }
}

