/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTable;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.PropertiesTableModel;
import adams.gui.core.UndoPanel;
import adams.gui.event.UndoEvent;
import adams.gui.print.PrintMouseListener;
import adams.gui.visualization.image.ImageOverlay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class ImagePanel
extends UndoPanel
implements StatusMessageHandler {
    private static final long serialVersionUID = -3102446345758890249L;
    protected PlaceholderFile m_CurrentFile;
    protected PaintPanel m_PaintPanel;
    protected BaseScrollPane m_ScrollPane;
    protected BaseStatusBar m_StatusBar;
    protected BasePanel m_PanelProperties;
    protected PropertiesTableModel m_ModelProperties;
    protected BaseTable m_TableProperties;
    protected BaseSplitPane m_SplitPane;
    protected Color m_BackgroundColor;
    protected boolean m_Modified;

    public ImagePanel() {
        super(Object.class, true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BackgroundColor = this.getBackground();
        this.m_Modified = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane();
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PaintPanel = new PaintPanel(this);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this.m_PaintPanel);
        this.m_ScrollPane = new BaseScrollPane(panel);
        this.m_SplitPane.setLeftComponent(this.m_ScrollPane);
        this.m_SplitPane.setLeftComponentHidden(false);
        this.m_PanelProperties = new BasePanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PanelProperties);
        this.m_SplitPane.setRightComponentHidden(true);
        this.m_ModelProperties = new PropertiesTableModel();
        this.m_TableProperties = new BaseTable(this.m_ModelProperties);
        this.m_TableProperties.setAutoResizeMode(0);
        this.m_PanelProperties.add(new BaseScrollPane(this.m_TableProperties));
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
        this.clear();
    }

    protected Vector getState() {
        Vector<Object> result = new Vector<Object>();
        result.add(this.getCurrentFile());
        result.add(this.getCurrentImage());
        result.add(this.m_Modified);
        result.add(this.getScale());
        return result;
    }

    protected void setState(Vector value) {
        this.setCurrentImage((BufferedImage)value.get(1));
        this.m_CurrentFile = (PlaceholderFile)value.get(0);
        this.m_Modified = (Boolean)value.get(2);
        this.setScale((Double)value.get(3));
    }

    public void addUndoPoint(String statusMsg, String undoComment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.showStatus(statusMsg);
            this.getUndo().addUndo(this.getState(), undoComment);
            this.showStatus("");
        }
    }

    public void setCurrentImage(BufferedImage value) {
        this.m_CurrentFile = null;
        this.m_PaintPanel.setCurrentImage(value);
        this.updateProperties();
    }

    public BufferedImage getCurrentImage() {
        return this.m_PaintPanel.getCurrentImage();
    }

    public void setCurrentFile(File value) {
        if (this.getCurrentImage() != null) {
            this.m_CurrentFile = value != null ? new PlaceholderFile(value) : null;
            this.updateProperties();
        }
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void setScale(double value) {
        this.m_PaintPanel.setScale(value);
    }

    public double getScale() {
        return this.m_PaintPanel.getScale();
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    protected JScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public void clear() {
        this.addUndoPoint("Saving undo data...", "Removing image");
        this.m_CurrentFile = null;
        this.m_PaintPanel.setCurrentImage(null);
        this.updateProperties();
        this.showStatus("");
        this.repaint();
    }

    public boolean load(File file) {
        boolean result;
        this.addUndoPoint("Saving undo data...", "Loading file '" + file + "'");
        try {
            file = new File(file.getAbsolutePath());
            this.m_PaintPanel.setCurrentImage(ImageIO.read(file));
            this.m_CurrentFile = new PlaceholderFile(file);
            result = true;
            this.updateProperties();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clear();
            result = false;
        }
        return result;
    }

    public boolean save(File file) {
        boolean result = false;
        if (this.m_PaintPanel.getCurrentImage() != null) {
            try {
                file = new File(file.getAbsolutePath());
                String formatName = ImageFileChooser.getWriterFormatName(file);
                if (formatName != null) {
                    ImageIO.write((RenderedImage)this.m_PaintPanel.getCurrentImage(), formatName, file);
                    this.m_CurrentFile = new PlaceholderFile(file);
                } else {
                    System.err.println("Failed to find format name for '" + file + "'!");
                }
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
        }
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public boolean getShowProperties() {
        return !this.m_SplitPane.isRightComponentHidden();
    }

    public void setShowProperties(boolean value) {
        this.m_SplitPane.setRightComponentHidden(!value);
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    protected void updateProperties() {
        Properties props = new Properties();
        BufferedImage image = this.getCurrentImage();
        if (image != null) {
            if (this.m_CurrentFile != null) {
                props.setProperty("File", "" + this.m_CurrentFile);
            }
            props.setInteger("Width", image.getWidth());
            props.setInteger("Height", image.getHeight());
        }
        this.m_ModelProperties = new PropertiesTableModel(props);
        this.m_TableProperties.setModel(this.m_ModelProperties);
        this.m_TableProperties.setOptimalColumnWidth();
    }

    @Override
    public void undoOccurred(UndoEvent e) {
    }

    public PaintPanel getPaintPanel() {
        return this.m_PaintPanel;
    }

    public void addImageOverlay(ImageOverlay io) {
        this.m_PaintPanel.addImageOverlay(io);
    }

    public void removeImageOverlay(ImageOverlay io) {
        this.m_PaintPanel.removeImageOverlay(io);
    }

    public static class PaintPanel
    extends BasePanel {
        private static final long serialVersionUID = 184259023085417961L;
        protected ImagePanel m_Owner;
        protected double m_Scale;
        protected BufferedImage m_CurrentImage;
        protected PrintMouseListener m_PrintMouseListener;
        protected HashSet<ImageOverlay> m_ImageOverlays;

        public PaintPanel(ImagePanel owner) {
            this.m_Owner = owner;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_CurrentImage = null;
            this.m_Scale = 1.0;
            this.m_ImageOverlays = new HashSet();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    PaintPanel.this.updateStatus(e.getPoint());
                    super.mouseMoved(e);
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int rotation = e.getWheelRotation();
                    double scale = PaintPanel.this.getScale();
                    scale = rotation < 0 ? (scale *= Math.pow(1.2, -rotation)) : (scale /= Math.pow(1.2, rotation));
                    PaintPanel.this.setScale(scale);
                    PaintPanel.this.updateStatus();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isMiddleClick(e)) {
                        PaintPanel.this.setScale(1.0);
                        PaintPanel.this.updateStatus();
                        e.consume();
                    } else if (MouseUtils.isRightClick(e)) {
                        PaintPanel.this.showPopup(e);
                        e.consume();
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            this.m_PrintMouseListener = new PrintMouseListener(this);
        }

        protected void updateStatus() {
            Point pos = this.getMousePosition();
            if (pos != null) {
                this.updateStatus(pos.getLocation());
            }
        }

        protected void updateStatus(Point pos) {
            if (this.getOwner() == null) {
                return;
            }
            int x = (int)((pos.getX() + 1.0) / this.m_Scale);
            int y = (int)((pos.getY() + 1.0) / this.m_Scale);
            this.getOwner().showStatus("X: " + x + "   " + "Y: " + y + "   " + "Zoom: " + Utils.doubleToString(this.getScale() * 100.0, 1) + "%");
        }

        protected void showPopup(MouseEvent e) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.setEnabled(this.getCurrentImage() != null);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(PaintPanel.this.getCurrentImage());
                }
            });
            menu.add(menuitem);
            menuitem = new JMenuItem("Export...", GUIHelper.getIcon("save.gif"));
            menuitem.setEnabled(this.getCurrentImage() != null);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaintPanel.this.m_PrintMouseListener.saveComponent();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            menu.show(this, e.getX(), e.getY());
        }

        public ImagePanel getOwner() {
            return this.m_Owner;
        }

        public void setCurrentImage(BufferedImage value) {
            this.m_CurrentImage = value;
            this.setScale(1.0);
            this.repaint();
        }

        public BufferedImage getCurrentImage() {
            return this.m_CurrentImage;
        }

        public void setScale(double value) {
            if (value > 0.0 && value <= 16.0) {
                int height;
                int width;
                this.m_Scale = value;
                if (this.m_CurrentImage != null) {
                    width = (int)((double)this.m_CurrentImage.getWidth() * this.m_Scale);
                    height = (int)((double)this.m_CurrentImage.getHeight() * this.m_Scale);
                } else {
                    width = 320;
                    height = 200;
                }
                this.setSize(new Dimension(width, height));
                this.setMinimumSize(new Dimension(width, height));
                this.setPreferredSize(new Dimension(width, height));
                this.getOwner().getScrollPane().getHorizontalScrollBar().setUnitIncrement(width / 25);
                this.getOwner().getScrollPane().getHorizontalScrollBar().setBlockIncrement(width / 10);
                this.getOwner().getScrollPane().getVerticalScrollBar().setUnitIncrement(height / 25);
                this.getOwner().getScrollPane().getVerticalScrollBar().setBlockIncrement(height / 10);
                this.getOwner().invalidate();
                this.getOwner().validate();
                this.repaint();
            }
        }

        public double getScale() {
            return this.m_Scale;
        }

        public void addImageOverlay(ImageOverlay io) {
            this.m_ImageOverlays.add(io);
        }

        public void removeImageOverlay(ImageOverlay io) {
            this.m_ImageOverlays.remove(io);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_CurrentImage != null) {
                ImageOverlay[] overlays;
                ((Graphics2D)g).scale(this.m_Scale, this.m_Scale);
                g.drawImage(this.m_CurrentImage, 0, 0, this.getOwner().getBackgroundColor(), null);
                for (ImageOverlay overlay : overlays = this.m_ImageOverlays.toArray(new ImageOverlay[this.m_ImageOverlays.size()])) {
                    overlay.paintOverlay(this, g);
                }
            }
        }
    }
}

