/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.ColorContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.NamedContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.sequence.XYSequenceContainer;
import java.awt.Color;
import java.util.Vector;

public class XYSequenceContainerManager
extends ContainerManager<XYSequenceContainer>
implements VisibilityContainerManager<XYSequenceContainer>,
NamedContainerManager,
ColorContainerManager {
    private static final long serialVersionUID = -8391985519481058665L;
    protected ContainerListManager m_Owner;
    protected AbstractColorProvider m_ColorProvider;

    public XYSequenceContainerManager(ContainerListManager owner) {
        this.m_Owner = owner;
        this.m_ColorProvider = new DefaultColorProvider();
        if (owner instanceof DataChangeListener) {
            this.addDataChangeListener((DataChangeListener)((Object)owner));
        }
    }

    public ContainerListManager getOwner() {
        return this.m_Owner;
    }

    @Override
    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
    }

    @Override
    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    @Override
    public Color getNextColor() {
        return this.m_ColorProvider.next();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_ColorProvider.resetColors();
    }

    @Override
    public XYSequenceContainer newContainer(Comparable o) {
        return new XYSequenceContainer(this, (XYSequence)o);
    }

    @Override
    public void add(XYSequenceContainer c) {
        c.setColor(this.getNextColor());
        super.add(c);
    }

    @Override
    public XYSequenceContainer remove(int index) {
        XYSequenceContainer result = (XYSequenceContainer)super.remove(index);
        this.m_ColorProvider.recycle(result.getColor());
        return result;
    }

    @Override
    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((XYSequenceContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int[] getVisibleIndices() {
        int i;
        Vector<Integer> indices = new Vector<Integer>();
        for (i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            indices.add(i);
        }
        int[] result = new int[indices.size()];
        for (i = 0; i < indices.size(); ++i) {
            result[i] = (Integer)indices.get(i);
        }
        return result;
    }

    @Override
    public Vector<XYSequenceContainer> getAllVisible() {
        Vector<XYSequenceContainer> result = new Vector<XYSequenceContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            XYSequenceContainer cont = (XYSequenceContainer)((XYSequenceContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    @Override
    public boolean isVisible(int index) {
        return ((XYSequenceContainer)this.get(index)).isVisible();
    }

    @Override
    public void setVisible(int index, boolean visible) {
        ((XYSequenceContainer)this.get(index)).setVisible(visible);
        this.notifyDataChangeListeners(new DataChangeEvent((ContainerManager)this, DataChangeEvent.Type.VISIBILITY, index));
    }

    @Override
    public XYSequenceContainer getVisible(int index) {
        XYSequenceContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (XYSequenceContainer)this.get(i);
            break;
        }
        return result;
    }

    @Override
    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }
}

