/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.parser.AbstractExpressionEvaluator;
import adams.parser.basedatetime.Parser;
import adams.parser.basedatetime.Scanner;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class BaseDateTimeExpression
extends AbstractExpressionEvaluator<Date> {
    private static final long serialVersionUID = -5923987640355752595L;

    @Override
    public String globalInfo() {
        return "Evaluates date/time expressions.\n\nFormat:\n" + this.getGrammar() + "\n" + "\n" + "Examples:\n" + "1999-12-31 01:02:03\n" + "1999-12-31 01:02:03 +1 MINUTE\n" + "NOW\n" + "+INF\n" + "NOW +1 YEAR\n" + "NOW +14 DAY\n" + "\n" + "Amounts can be chained as well:\n" + "NOW -1 MONTH +1 DAY\n" + "\n" + "START and END can only be set programmatically; by default they are equal to -INF and +INF.";
    }

    @Override
    public String getGrammar() {
        return "(<date>|NOW|-INF|+INF|START|END) [(+&lt;int&gt;|-&lt;int&gt;) (SECOND|MINUTE|HOUR|DAY|WEEK|MONTH|YEAR)]";
    }

    @Override
    protected String getDefaultExpression() {
        return "NOW";
    }

    @Override
    public String expressionTipText() {
        return "The boolean expression to evaluate (must evaluate to a boolean).";
    }

    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getSystemErr().println("Failed to parse the value of symbol '" + name + "': " + value);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    public Date evaluate() throws Exception {
        return BaseDateTimeExpression.evaluate(this.m_Expression);
    }

    public Date evaluate(Date start, Date end) throws Exception {
        return BaseDateTimeExpression.evaluate(this.m_Expression, start, end);
    }

    public static Date evaluate(String expr) throws Exception {
        return BaseDateTimeExpression.evaluate(expr, null, null);
    }

    public static Date evaluate(String expr, Date start, Date end) throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setStart(start);
        parser.setEnd(end);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        BaseDateTimeExpression.runEvaluator(BaseDateTimeExpression.class, args);
    }
}

