/*
 * Decompiled with CFR 0.152.
 */
package adams.run;

import adams.core.base.BasePassword;
import adams.db.AbstractIndexedTable;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionEstablisher;
import adams.db.DatabaseConnectionParameterHandler;
import adams.run.RunScheme;

public abstract class RunDatabaseScheme
extends RunScheme
implements DatabaseConnectionEstablisher,
DatabaseConnectionParameterHandler {
    private static final long serialVersionUID = -9114743801790739455L;
    protected transient DatabaseConnection m_DbConn;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;

    @Override
    protected void initialize() {
        this.m_DbConn = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", DatabaseConnection.getSingleton().getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", DatabaseConnection.getSingleton().getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", DatabaseConnection.getSingleton().getDefaultPassword(), false);
    }

    @Override
    public void setURL(String value) {
        this.m_URL = value;
    }

    @Override
    public String getURL() {
        return this.m_URL;
    }

    @Override
    public String URLTipText() {
        return "The database URL.";
    }

    @Override
    public void setUser(String value) {
        this.m_User = value;
    }

    @Override
    public String getUser() {
        return this.m_User;
    }

    @Override
    public String userTipText() {
        return "The database user.";
    }

    @Override
    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    @Override
    public BasePassword getPassword() {
        return this.m_Password;
    }

    @Override
    public String passwordTipText() {
        return "The password of the database user.";
    }

    @Override
    public void establishDatabaseConnection() {
        this.m_DbConn = DatabaseConnection.getSingleton(this.m_URL, this.m_User, this.m_Password);
    }

    @Override
    protected void preRun() throws Exception {
        super.preRun();
        this.getSystemOut().println("- Connecting to database");
        this.establishDatabaseConnection();
        this.getSystemOut().println("- Initializing tables");
        AbstractIndexedTable.initTables(this.m_DbConn);
    }

    @Override
    protected void postRun() throws Exception {
        super.postRun();
        this.getSystemOut().println("- Disconnecting from database");
        this.m_DbConn.disconnect();
        this.m_DbConn = null;
    }
}

