/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractMatchWekaInstanceAgainstHeader;
import adams.flow.control.StorageHandler;
import adams.flow.control.StorageName;
import weka.core.Instances;

public class MatchWekaInstanceAgainstStorageHeader
extends AbstractMatchWekaInstanceAgainstHeader {
    private static final long serialVersionUID = 5788507217652026285L;
    protected StorageName m_Header;

    public String globalInfo() {
        return "Matches an Instance against a dataset header from storage, i.e., it automatically converts STRING attributes into NOMINAL ones and vice versa.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("header", "header", (Object)new StorageName());
    }

    public void setHeader(StorageName value) {
        this.m_Header = value;
        this.reset();
    }

    public StorageName getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the storage object that represents the dataset header to use.";
    }

    @Override
    protected Instances getDatasetHeader() {
        if (!(this.getOwner() instanceof StorageHandler)) {
            throw new IllegalStateException("No access to " + StorageHandler.class.getName() + "!");
        }
        Object result = ((StorageHandler)this.m_Owner).getStorage().get(this.m_Header);
        if (result == null) {
            throw new IllegalStateException("No storage value available: " + this.m_Header);
        }
        if (!(result instanceof Instances)) {
            throw new IllegalStateException("Storage value '" + this.m_Header + "' not of type " + Instances.class.getName() + "!");
        }
        return (Instances)result;
    }
}

