/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.report.AbstractField;
import adams.data.report.Field;
import adams.data.report.Report;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ReportToWekaInstance
extends AbstractConversion {
    private static final long serialVersionUID = 124581970397295630L;
    protected Field[] m_Fields;
    protected Instances m_Header;

    public String globalInfo() {
        return "Converts a report into a weka.core.Instance objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "fields", (Object)new Field[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    public void setFields(Field[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public Field[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields from the report to turn into attributes of the generated instance.";
    }

    public Class accepts() {
        return Report.class;
    }

    public Class generates() {
        return Instance.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        Report report = (Report)this.m_Input;
        if (this.m_Header == null) {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            block8: for (i = 0; i < this.m_Fields.length; ++i) {
                switch (this.m_Fields[i].getDataType()) {
                    case NUMERIC: {
                        atts.add(new Attribute(this.m_Fields[i].getName()));
                        continue block8;
                    }
                    case BOOLEAN: {
                        ArrayList<String> attValues = new ArrayList<String>();
                        attValues.add("false");
                        attValues.add("true");
                        atts.add(new Attribute(this.m_Fields[i].getName(), attValues));
                        continue block8;
                    }
                    default: {
                        atts.add(new Attribute(this.m_Fields[i].getName(), (List)null));
                    }
                }
            }
            this.m_Header = new Instances(((Object)((Object)this)).getClass().getName(), atts, 0);
        }
        double[] values = new double[this.m_Header.numAttributes()];
        for (i = 0; i < this.m_Fields.length; ++i) {
            if (report.hasValue((AbstractField)this.m_Fields[i])) {
                switch (this.m_Fields[i].getDataType()) {
                    case NUMERIC: {
                        values[i] = report.getDoubleValue((AbstractField)this.m_Fields[i]);
                        break;
                    }
                    case BOOLEAN: {
                        if (report.getBooleanValue((AbstractField)this.m_Fields[i]).booleanValue()) {
                            values[i] = 1.0;
                            break;
                        }
                        values[i] = 0.0;
                        break;
                    }
                    default: {
                        values[i] = this.m_Header.attribute(i).addStringValue("" + report.getValue((AbstractField)this.m_Fields[i]));
                        break;
                    }
                }
                continue;
            }
            values[i] = Utils.missingValue();
        }
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_Header);
        return result;
    }
}

