/*
 * Decompiled with CFR 0.152.
 */
package adams.data.utils;

import weka.core.Statistics;

public class SAXUtils {
    public static double[] PAA(double[] inarray, int numwindows) {
        double width = (double)inarray.length / (double)numwindows;
        int whole = (int)Math.floor(width);
        double[] ret = new double[numwindows];
        int currpos = 0;
        double remainder1 = 0.0;
        double remainder2 = width - (remainder1 + (double)whole);
        for (int i = 0; i < numwindows; ++i) {
            double sum = remainder1 * inarray[currpos];
            if (remainder1 != 0.0) {
                // empty if block
            }
            for (int j = ++currpos; j < currpos + whole; ++j) {
                sum += inarray[j];
            }
            currpos += whole;
            if (i != numwindows - 1) {
                sum += inarray[currpos] * remainder2;
            }
            remainder1 = 1.0 - remainder2;
            whole = (int)Math.floor(width - remainder1);
            remainder2 = width - (remainder1 + (double)whole);
            ret[i] = sum / width;
        }
        return ret;
    }

    public static double[] toSAX(double[] inarray, int numwindows, double[] bps) {
        double[] sax = SAXUtils.PAA(inarray, numwindows);
        for (int x = 0; x < sax.length; ++x) {
            int saxlabel = bps.length;
            for (int i = 0; i < bps.length; ++i) {
                if (!(sax[x] < bps[i])) continue;
                saxlabel = i;
                break;
            }
            sax[x] = saxlabel;
        }
        return sax;
    }

    private static double max(int bin, double[] bps) {
        if (bin >= bps.length) {
            return Double.POSITIVE_INFINITY;
        }
        return bps[bin];
    }

    private static double min(int bin, double[] bps) {
        if (bin == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return bps[bin - 1];
    }

    public static double[][] calcDistMatrix(double[] bps) {
        double[][] ret = new double[bps.length + 1][bps.length + 1];
        for (int r = 0; r < bps.length + 1; ++r) {
            for (int c = 0; c < bps.length + 1; ++c) {
                ret[r][c] = Math.abs(r - c) <= 1 ? 0.0 : bps[Math.max(r, c) - 1] - bps[Math.min(r, c)];
            }
        }
        return ret;
    }

    public static double minDist(double[] q, double[] c, double[][] distMatrix, int orig_n) {
        double ret = 0.0;
        for (int i = 0; i < c.length; ++i) {
            ret += distMatrix[(int)q[i]][(int)c[i]] * distMatrix[(int)q[i]][(int)c[i]];
        }
        return Math.sqrt(ret) * Math.sqrt((double)orig_n / (double)c.length);
    }

    public static double[] calcBreakPoints(int bins) {
        double[] ret = new double[bins - 1];
        double dbins = bins;
        if (bins % 2 == 0) {
            int num = (int)(dbins - 2.0) / 2;
            double width = 0.5 / (dbins / 2.0);
            ret[(int)((dbins - 2.0) / 2.0)] = 0.0;
            for (int i = 1; i <= num; ++i) {
                ret[(int)((dbins - 2.0) / 2.0) + i] = Statistics.normalInverse((double)(0.5 + (double)i * width));
                ret[(int)((dbins - 2.0) / 2.0) - i] = -ret[(int)((dbins - 2.0) / 2.0) + i];
            }
        } else {
            int num = (int)(dbins - 3.0) / 2;
            double width = 1.0 / dbins;
            ret[(int)((dbins - 1.0) / 2.0)] = Statistics.normalInverse((double)(0.5 + width / 2.0));
            ret[(int)((dbins - 1.0) / 2.0) - 1] = -ret[(int)((dbins - 1.0) / 2.0)];
            for (int i = 1; i <= num; ++i) {
                ret[(int)((dbins - 1.0) / 2.0) + i] = Statistics.normalInverse((double)(0.5 + width / 2.0 + (double)i * width));
                ret[(int)((dbins - 1.0) / 2.0) - (i + 1)] = -ret[(int)((dbins - 1.0) / 2.0) + i];
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        double[] get = SAXUtils.calcBreakPoints(3);
        get = SAXUtils.calcBreakPoints(4);
        double[][] get2 = SAXUtils.calcDistMatrix(get);
        get = SAXUtils.calcBreakPoints(5);
    }
}

