/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.WekaExperimentFile;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Vector;
import weka.experiment.Experiment;

public class WekaExperiment
extends AbstractTransformer {
    private static final long serialVersionUID = -1127504846960163422L;
    protected WekaExperimentFile m_ExperimentFile;
    protected boolean m_NoCheck;

    public String globalInfo() {
        return "Represents a Weka experiment, stored in a file. Can be setup from inside the flow.\nVia the input port, additional datasets can be inserted into the experiment. This allows one to define a template experiment and then just run it over various datasets without every having to change the experiment setup itself.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "experimentFile", (Object)new WekaExperimentFile("."));
        this.m_OptionManager.add("no-check", "noCheck", (Object)false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("experimentFile");
        if (variable != null) {
            return variable;
        }
        if (this.m_ExperimentFile != null) {
            return this.m_ExperimentFile.toString();
        }
        return null;
    }

    public void setExperimentFile(WekaExperimentFile value) {
        this.m_ExperimentFile = value;
        this.reset();
    }

    public WekaExperimentFile getExperimentFile() {
        return this.m_ExperimentFile;
    }

    public String experimentFileTipText() {
        return "The file the experiment is stored in.";
    }

    public void setNoCheck(boolean value) {
        this.m_NoCheck = value;
        this.reset();
    }

    public boolean getNoCheck() {
        return this.m_NoCheck;
    }

    public String noCheckTipText() {
        return "If set to true, the experiment file must not be present at setUp-time; necessary if file gets generated on-the-fly.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class, File.class, File[].class, String.class, String[].class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_NoCheck && !this.m_ExperimentFile.exists()) {
            result = "Experiment file '" + this.m_ExperimentFile.getAbsolutePath() + "' does not exist!";
        }
        return result;
    }

    protected String doExecute() {
        Experiment exp;
        String result = null;
        try {
            exp = Experiment.read((String)this.m_ExperimentFile.getAbsolutePath());
        }
        catch (Exception e) {
            exp = null;
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        if (this.m_InputToken != null) {
            int i;
            Vector<File> files = new Vector<File>();
            if (this.m_InputToken.getPayload() instanceof File) {
                files.add(((File)this.m_InputToken.getPayload()).getAbsoluteFile());
            } else if (this.m_InputToken.getPayload() instanceof File[]) {
                File[] tmpFiles = (File[])this.m_InputToken.getPayload();
                for (i = 0; i < tmpFiles.length; ++i) {
                    files.add(tmpFiles[i].getAbsoluteFile());
                }
            } else if (this.m_InputToken.getPayload() instanceof String) {
                files.add(new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsoluteFile());
            } else if (this.m_InputToken.getPayload() instanceof String[]) {
                String[] tmpStr = (String[])this.m_InputToken.getPayload();
                for (i = 0; i < tmpStr.length; ++i) {
                    files.add(new PlaceholderFile(tmpStr[i]).getAbsoluteFile());
                }
            }
            if (this.isDebugOn()) {
                this.debug("Adding files: " + files);
            }
            for (i = 0; i < files.size(); ++i) {
                exp.getDatasets().addElement(files.get(i));
            }
        }
        if (result == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("Initializing experiment...");
                }
                exp.initialize();
                if (this.isDebugOn()) {
                    this.debug("Running experiment...");
                }
                exp.runExperiment();
                if (this.isDebugOn()) {
                    this.debug("Post-processing experiment...");
                }
                exp.postProcess();
                if (this.isDebugOn()) {
                    this.debug("Finished experiment!");
                }
                this.m_OutputToken = new Token((Object)exp);
            }
            catch (Exception e) {
                result = e.toString();
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{Experiment.class};
    }
}

