/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise.genetic;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class PackDataDef
implements Serializable {
    private static final long serialVersionUID = -4776734918844200382L;
    protected Hashtable<String, Integer> m_sort_packed = new Hashtable();
    protected Vector<DataInfo> m_packed = new Vector();

    public int size() {
        int count = 0;
        for (DataInfo di : this.m_packed) {
            count += di.m_bits;
        }
        return count;
    }

    public void add(String name, int bits, double min, double max) {
        DataInfo di = new DataInfo(name, bits, min, max);
        this.m_sort_packed.put(name, this.m_packed.size());
        this.m_packed.add(di);
    }

    public void setMinMax(String name, double min, double max) {
        Integer pos = this.m_sort_packed.get(name);
        if (pos == null) {
            System.err.println("not there:" + name);
        }
        DataInfo di = this.m_packed.get(pos);
        di.resetMinMax(min, max);
    }

    public DataInfo get(String name) {
        Integer pos = this.m_sort_packed.get(name);
        if (pos == null) {
            System.err.println("not there:" + name);
            return null;
        }
        DataInfo di = this.m_packed.get(pos);
        return di;
    }

    public class DataInfo {
        public String m_name;
        public int m_bits;
        public double m_max;
        public double m_min;
        protected double m_scale;

        public DataInfo(String name, int bits, double min, double max) {
            this.m_bits = bits;
            this.m_max = max;
            this.m_min = min;
            this.m_name = name;
            this.m_scale = (this.m_max - this.m_min) / (double)this.getMaxVal();
        }

        public String getName() {
            return this.m_name;
        }

        public void resetMinMax(double min, double max) {
            this.m_max = max;
            this.m_min = min;
            this.m_scale = (this.m_max - this.m_min) / (double)this.getMaxVal();
        }

        public int toBits(double val) {
            return (int)((val - this.m_min) / this.m_scale);
        }

        public double fromBits(int bits) {
            return (double)bits * this.m_scale + this.m_min;
        }

        public int getMaxVal() {
            return (1 << this.m_bits) - 1;
        }
    }
}

