/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.trees.m5.Rule2;
import weka.classifiers.trees.m5.RuleNode2;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.RemoveUseless;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public abstract class M5Base2
extends AbstractClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4022221950191647679L;
    private Instances m_instances;
    protected FastVector m_ruleSet;
    private boolean m_generateRules = false;
    private boolean m_unsmoothedPredictions = false;
    private ReplaceMissingValues m_replaceMissing;
    private NominalToBinary m_nominalToBinary;
    private RemoveUseless m_removeUseless;
    protected boolean m_saveInstances = false;
    protected boolean m_regressionTree;
    protected boolean m_useUnpruned = false;
    protected double m_minNumInstances = 4.0;

    public String globalInfo() {
        return "M5Base. Implements base routines for generating M5 Model trees and rules\nThe original algorithm M5 was invented by R. Quinlan and Yong Wang made improvements.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ross J. Quinlan");
        result.setValue(TechnicalInformation.Field.TITLE, "Learning with Continuous Classes");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "5th Australian Joint Conference on Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.PAGES, "343-348");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "World Scientific");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Singapore");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Y. Wang and I. H. Witten");
        additional.setValue(TechnicalInformation.Field.TITLE, "Induction of model trees for predicting continuous classes");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Poster papers of the 9th European Conference on Machine Learning");
        additional.setValue(TechnicalInformation.Field.YEAR, "1997");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tUse unpruned tree/rules", "N", 0, "-N"));
        newVector.addElement(new Option("\tUse unsmoothed predictions", "U", 0, "-U"));
        newVector.addElement(new Option("\tBuild regression tree/rule rather than a model tree/rule", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet minimum number of instances per leaf\n\t(default 4)", "M", 1, "-M <minimum number of instances>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setUnpruned(Utils.getFlag((char)'N', (String[])options));
        this.setUseUnsmoothed(Utils.getFlag((char)'U', (String[])options));
        this.setBuildRegressionTree(Utils.getFlag((char)'R', (String[])options));
        String optionString = Utils.getOption((char)'M', (String[])options);
        if (optionString.length() != 0) {
            this.setMinNumInstances(new Double(optionString));
        }
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        if (this.getUnpruned()) {
            options[current++] = "-N";
        }
        if (this.getUseUnsmoothed()) {
            options[current++] = "-U";
        }
        if (this.getBuildRegressionTree()) {
            options[current++] = "-R";
        }
        options[current++] = "-M";
        options[current++] = "" + this.getMinNumInstances();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String unprunedTipText() {
        return "Whether unpruned tree/rules are to be generated.";
    }

    public void setUnpruned(boolean unpruned) {
        this.m_useUnpruned = unpruned;
    }

    public boolean getUnpruned() {
        return this.m_useUnpruned;
    }

    public String generateRulesTipText() {
        return "Whether to generate rules (decision list) rather than a tree.";
    }

    protected void setGenerateRules(boolean u) {
        this.m_generateRules = u;
    }

    protected boolean getGenerateRules() {
        return this.m_generateRules;
    }

    public String useUnsmoothedTipText() {
        return "Whether to use unsmoothed predictions.";
    }

    public void setUseUnsmoothed(boolean s) {
        this.m_unsmoothedPredictions = s;
    }

    public boolean getUseUnsmoothed() {
        return this.m_unsmoothedPredictions;
    }

    public String buildRegressionTreeTipText() {
        return "Whether to generate a regression tree/rule instead of a model tree/rule.";
    }

    public boolean getBuildRegressionTree() {
        return this.m_regressionTree;
    }

    public void setBuildRegressionTree(boolean newregressionTree) {
        this.m_regressionTree = newregressionTree;
    }

    public String minNumInstancesTipText() {
        return "The minimum number of instances to allow at a leaf node.";
    }

    public void setMinNumInstances(double minNum) {
        this.m_minNumInstances = minNum;
    }

    public double getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public Capabilities getCapabilities() {
        return new LinearRegression().getCapabilities();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_instances = new Instances(data);
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(this.m_instances);
        this.m_instances = Filter.useFilter((Instances)this.m_instances, (Filter)this.m_replaceMissing);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(this.m_instances);
        this.m_instances = Filter.useFilter((Instances)this.m_instances, (Filter)this.m_nominalToBinary);
        this.m_removeUseless = new RemoveUseless();
        this.m_removeUseless.setInputFormat(this.m_instances);
        this.m_instances = Filter.useFilter((Instances)this.m_instances, (Filter)this.m_removeUseless);
        this.m_instances.randomize(new Random(1L));
        this.m_ruleSet = new FastVector();
        if (this.m_generateRules) {
            Rule2 tempRule;
            Instances tempInst = this.m_instances;
            do {
                tempRule = new Rule2();
                tempRule.setSmoothing(!this.m_unsmoothedPredictions);
                tempRule.setRegressionTree(this.m_regressionTree);
                tempRule.setUnpruned(this.m_useUnpruned);
                tempRule.setSaveInstances(false);
                tempRule.setMinNumInstances(this.m_minNumInstances);
                tempRule.buildClassifier(tempInst);
                this.m_ruleSet.addElement((Object)tempRule);
            } while ((tempInst = tempRule.notCoveredInstances()).numInstances() > 0);
        } else {
            Rule2 tempRule = new Rule2();
            tempRule.setUseTree(true);
            tempRule.setSmoothing(!this.m_unsmoothedPredictions);
            tempRule.setSaveInstances(this.m_saveInstances);
            tempRule.setRegressionTree(this.m_regressionTree);
            tempRule.setUnpruned(this.m_useUnpruned);
            tempRule.setMinNumInstances(this.m_minNumInstances);
            Instances temp_train = this.m_instances;
            tempRule.buildClassifier(temp_train);
            this.m_ruleSet.addElement((Object)tempRule);
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    public double classifyInstance(Instance inst) throws Exception {
        double prediction = 0.0;
        boolean success = false;
        this.m_replaceMissing.input(inst);
        inst = this.m_replaceMissing.output();
        this.m_nominalToBinary.input(inst);
        inst = this.m_nominalToBinary.output();
        this.m_removeUseless.input(inst);
        inst = this.m_removeUseless.output();
        if (this.m_ruleSet == null) {
            throw new Exception("Classifier has not been built yet!");
        }
        if (!this.m_generateRules) {
            Rule2 temp = (Rule2)this.m_ruleSet.elementAt(0);
            return temp.classifyInstance(inst);
        }
        for (int i = 0; i < this.m_ruleSet.size(); ++i) {
            boolean cont = false;
            Rule2 temp = (Rule2)this.m_ruleSet.elementAt(i);
            try {
                prediction = temp.classifyInstance(inst);
                success = true;
            }
            catch (Exception e) {
                cont = true;
            }
            if (!cont) break;
        }
        if (!success) {
            System.out.println("Error in predicting (DecList)");
        }
        return prediction;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_ruleSet == null) {
            return "Classifier hasn't been built yet!";
        }
        if (this.m_generateRules) {
            text.append("M5 " + (this.m_useUnpruned ? "unpruned " : "pruned ") + (this.m_regressionTree ? "regression " : "model ") + "rules ");
            if (!this.m_unsmoothedPredictions) {
                text.append("\n(using smoothed linear models) ");
            }
            text.append(":\n");
            text.append("Number of Rules : " + this.m_ruleSet.size() + "\n\n");
            for (int j = 0; j < this.m_ruleSet.size(); ++j) {
                Rule2 temp = (Rule2)this.m_ruleSet.elementAt(j);
                text.append("Rule: " + (j + 1) + "\n");
                text.append(temp.toString());
            }
        } else {
            Rule2 temp = (Rule2)this.m_ruleSet.elementAt(0);
            text.append(temp.toString());
        }
        return text.toString();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (M5)");
    }

    public double measureNumRules() {
        if (this.m_generateRules) {
            return this.m_ruleSet.size();
        }
        return ((Rule2)this.m_ruleSet.elementAt((int)0)).m_topOfTree.numberOfLinearModels();
    }

    public RuleNode2 getM5RootNode() {
        Rule2 temp = (Rule2)this.m_ruleSet.elementAt(0);
        return temp.getM5RootNode();
    }
}

