/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ConsoleObject;
import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.Conversion;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Vector;

public class ArrayConsumer
extends AbstractRecursiveOptionConsumer<String[], String[]> {
    private static final long serialVersionUID = 3756322164593713820L;

    @Override
    public String globalInfo() {
        return "Processes the string array, commonly obtained from the command-line.";
    }

    @Override
    protected OptionHandler initOutput() {
        OptionHandler result;
        try {
            result = (OptionHandler)Class.forName(Conversion.rename(((String[])this.m_Input)[0])).newInstance();
            ((String[])this.m_Input)[0] = "";
        }
        catch (Exception e) {
            String msg = "Failed to initialize output:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            result = null;
        }
        return result;
    }

    @Override
    protected String[] convertToInput(String s) {
        try {
            return OptionUtils.splitOptions(s);
        }
        catch (Exception e) {
            String msg = "Failed to convert to input:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            return null;
        }
    }

    @Override
    protected void processOption(BooleanOption option, String[] values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        method.invoke((Object)option.getOptionHandler(), new Boolean(!option.isInvertingFlag()));
    }

    protected String extractClassname(String cmdline) {
        int pos = cmdline.indexOf(32);
        String result = pos > -1 ? cmdline.substring(0, pos) : cmdline;
        result = Conversion.rename(result);
        return result;
    }

    @Override
    protected void processOption(ClassOption option, String[] values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.length);
        for (int i = 0; i < values.length; ++i) {
            if (Variables.isPlaceholder(values[i])) {
                option.setVariable(values[i]);
                return;
            }
            Object object = Class.forName(this.extractClassname(values[i])).newInstance();
            if (object instanceof OptionHandler) {
                ArrayConsumer consumer = new ArrayConsumer();
                consumer.setDebugLevel(this.getDebugLevel());
                object = consumer.fromString(values[i]);
                this.m_Errors.addAll(consumer.getErrors());
                this.m_Warnings.addAll(consumer.getWarnings());
                consumer.cleanUp();
            } else {
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(object);
                object = handler.fromCommandLine(values[i]);
            }
            Array.set(objects, i, object);
            this.checkDeprecation(object);
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    @Override
    protected void processOption(AbstractArgumentOption option, String[] values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.length);
        for (int i = 0; i < values.length; ++i) {
            if (Variables.isPlaceholder(values[i])) {
                option.setVariable(values[i]);
                return;
            }
            Array.set(objects, i, option.valueOf(values[i]));
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    protected String[] collectValues(AbstractOption option, String[] input) {
        Vector<String> result = new Vector<String>();
        boolean hasArg = option instanceof AbstractArgumentOption;
        String optionStr = this.getOptionIdentifier(option);
        for (int i = 0; i < input.length; ++i) {
            if (!input[i].equals(optionStr)) continue;
            input[i] = "";
            if (!hasArg || i >= input.length - 1) continue;
            result.add(input[++i]);
            input[i] = "";
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void doConsume(OptionManager manager, String[] input) {
        int i = 0;
        while (i < input.length) {
            String cmdline = input[i];
            if (cmdline.length() == 0) {
                ++i;
                continue;
            }
            if (cmdline.startsWith("-")) {
                String msg;
                cmdline = cmdline.substring(1);
                AbstractOption option = manager.findByFlag(cmdline);
                String[] values = null;
                if (option == null) {
                    msg = "Failed to find option (" + manager.getOwner().getClass().getName() + "): " + cmdline;
                    this.logWarning(msg);
                    this.getSystemErr().println(msg);
                    input[i] = "";
                    if (++i < input.length && !input[i].startsWith("-")) {
                        input[i] = "";
                    }
                } else {
                    if (option instanceof AbstractArgumentOption) {
                        values = this.collectValues(option, input);
                        if (values.length == 0) {
                            msg = "No argument supplied for option '" + option + "' (" + manager.getOwner().getClass().getName() + ")!";
                            this.logWarning(msg);
                            this.getSystemErr().println(msg);
                        }
                    } else if (option instanceof BooleanOption) {
                        this.collectValues(option, input);
                    }
                    try {
                        this.processOption(option, values);
                    }
                    catch (Exception e) {
                        msg = "Failed to process option '" + this.getOptionIdentifier(option) + "':";
                        this.logError(msg + " " + e);
                        this.getSystemErr().println(msg);
                        this.getSystemErr().printStackTrace(e);
                    }
                }
            }
            ++i;
        }
    }

    public static void setOptions(OptionHandler handler, String[] options) {
        ArrayConsumer.setOptions(handler, options, true);
    }

    public static void setOptions(OptionHandler handler, String[] options, boolean remaining) {
        String msg;
        ArrayConsumer consumer = new ArrayConsumer();
        consumer.consume(handler, options);
        if (remaining && (msg = OptionUtils.checkRemainingOptions(options)) != null) {
            if (handler instanceof ConsoleObject) {
                ((ConsoleObject)((Object)handler)).getSystemErr().println(msg);
            } else {
                System.err.println(msg);
            }
        }
    }
}

