/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class ArrayElement
extends AbstractTransformer {
    private static final long serialVersionUID = -3483275959738804271L;
    protected String m_Index;
    protected Index m_ActualIndex;

    @Override
    public String globalInfo() {
        return "Picks an element from an array and forwards only this element.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", "1");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ActualIndex = new Index();
    }

    public void setIndex(String value) {
        this.m_Index = value;
        this.reset();
    }

    public String getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The 1-based index of the element to pick ('first' and 'last' are accepted as well).";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("index");
        return "Index = " + (variable == null ? this.m_Index : variable);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object[] array = (Object[])this.m_InputToken.getPayload();
            this.m_ActualIndex.setIndex(this.m_Index);
            this.m_ActualIndex.setMax(array.length);
            this.m_OutputToken = new Token(array[this.m_ActualIndex.getIntIndex()]);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

