/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractInteractiveTransformer;
import javax.swing.JOptionPane;

public class ConfirmationDialog
extends AbstractInteractiveTransformer {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_Message;
    protected boolean m_UseCustomTokens;
    protected String m_YesToken;
    protected String m_NoToken;

    @Override
    public String globalInfo() {
        return "Pops up a confirmation dialog, prompting the user to select 'yes', 'no' or 'cancel'.\nIf no custom tokens are used, the current token is only forwarded when the user selects 'yes'. Otherwise the token simply gets dropped.\nIn case of custom tokens, depending on the user's selection, either the user-defined 'yes' string or the 'no' string get forwarded as string tokens.\nClosing the dialog gets interpreted as selecting the 'cancel' button.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Continue with processing of token?");
        this.m_OptionManager.add("custom-tokens", "useCustomTokens", false);
        this.m_OptionManager.add("yes-token", "yesToken", "");
        this.m_OptionManager.add("no-token", "noToken", "");
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("message");
        String result = variable != null ? variable : this.m_Message;
        if (this.m_UseCustomTokens) {
            result = result + ", using custom tokens";
        }
        if (this.m_StopFlowIfCanceled) {
            result = result + " [stops flow if canceled]";
        }
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with.";
    }

    public void setUseCustomTokens(boolean value) {
        this.m_UseCustomTokens = value;
        this.reset();
    }

    public boolean getUseCustomTokens() {
        return this.m_UseCustomTokens;
    }

    public String useCustomTokensTipText() {
        return "If enabled, custom string tokens are forwarded based on the selection the user makes; otherwise the current token gets forwarded when the user selects 'yes' and nothing for 'no'.";
    }

    public void setYesToken(String value) {
        this.m_YesToken = value;
        this.reset();
    }

    public String getYesToken() {
        return this.m_YesToken;
    }

    public String yesTokenTipText() {
        return "The string to forward as token if the user chooses 'yes' in case custom tokens are enabled.";
    }

    public void setNoToken(String value) {
        this.m_NoToken = value;
        this.reset();
    }

    public String getNoToken() {
        return this.m_NoToken;
    }

    public String noTokenTipText() {
        return "The string to forward as token if the user chooses 'no' in case custom tokens are enabled.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_UseCustomTokens) {
            return new Class[]{String.class};
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public boolean doInteract() {
        boolean canceled;
        this.m_OutputToken = null;
        int retVal = JOptionPane.showConfirmDialog(null, this.m_Message);
        boolean bl = canceled = retVal == 2 || retVal == -1;
        if (!canceled) {
            if (this.m_UseCustomTokens) {
                if (retVal == 0) {
                    this.m_OutputToken = new Token(this.m_YesToken);
                } else if (retVal == 1) {
                    this.m_OutputToken = new Token(this.m_NoToken);
                }
            } else if (retVal == 0) {
                this.m_OutputToken = this.m_InputToken;
            }
        }
        return !canceled;
    }
}

