/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Properties;
import adams.db.LogEntry;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class MakeLogEntry
extends AbstractTransformer {
    private static final long serialVersionUID = -6516304745462094703L;
    public static final String DEFAULT_TYPE = "Error";
    protected String m_LogType;
    protected String m_LogSource;

    @Override
    public String globalInfo() {
        return "Creates a log entry from the incoming token. The incoming string gets added as the 'error' message in the log entry.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("log-type", "logType", "");
        this.m_OptionManager.add("log-source", "logSource", "");
    }

    @Override
    public String getQuickInfo() {
        String result = "";
        String variable = this.getOptionManager().getVariableForProperty("logType");
        result = variable != null ? result + variable : result + (this.m_LogType.length() == 0 ? "-none-" : this.m_LogType);
        result = result + "/";
        variable = this.getOptionManager().getVariableForProperty("logSource");
        result = variable != null ? result + variable : result + (this.m_LogSource.length() == 0 ? "-none-" : this.m_LogSource);
        return result;
    }

    public void setLogType(String value) {
        this.m_LogType = value;
        this.reset();
    }

    public String getLogType() {
        return this.m_LogType;
    }

    public String logTypeTipText() {
        return "The value to use as 'type' field in the log entries; 'Error' is used by default if left empty.";
    }

    public void setLogSource(String value) {
        this.m_LogSource = value;
        this.reset();
    }

    public String getLogSource() {
        return this.m_LogSource;
    }

    public String logSourceTipText() {
        return "The value to use as 'source' field in the log entries; the actor's full name is used by default if left empty.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Properties props = new Properties();
        props.setProperty("Errors", (String)this.m_InputToken.getPayload());
        LogEntry log = new LogEntry();
        if (this.m_LogType.length() == 0) {
            log.setType(DEFAULT_TYPE);
        } else {
            log.setType(this.m_LogType);
        }
        if (this.m_LogSource.length() == 0) {
            log.setSource(this.getFullName());
        } else {
            log.setSource(this.m_LogSource);
        }
        log.setStatus("New");
        log.setMessage(props);
        this.m_OutputToken = new Token(log);
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{LogEntry.class};
    }
}

