/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchPanel
extends BasePanel {
    private static final long serialVersionUID = 984508072481111930L;
    protected LayoutType m_LayoutType;
    protected boolean m_RegExpEnabled;
    protected boolean m_Incremental;
    protected String m_Prefix;
    protected String m_ButtonCaption;
    protected JLabel m_LabelPrefix;
    protected JTextField m_TextSearch;
    protected JCheckBox m_CheckboxRegExp;
    protected JButton m_ButtonSearch;
    protected JPanel m_PanelWidgets;
    protected GridLayout m_LayoutWidgets;
    protected HashSet<SearchListener> m_SearchListeners;
    protected int m_MinimumChars;
    protected String m_LastSearch;

    public SearchPanel(LayoutType layout, boolean regExp) {
        this(layout, regExp, null, "_Search");
    }

    public SearchPanel(LayoutType layout, boolean regExp, String prefix, String button) {
        this(layout, regExp, prefix, false, button);
    }

    public SearchPanel(LayoutType layout, boolean regExp, String prefix, boolean incremental, String button) {
        this.m_LayoutType = layout;
        this.m_RegExpEnabled = regExp;
        this.m_Prefix = prefix;
        this.m_ButtonCaption = incremental ? null : button;
        this.m_Incremental = incremental;
        this.initGUI();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LayoutType = null;
        this.m_SearchListeners = new HashSet();
        this.m_MinimumChars = 1;
        this.m_LastSearch = "";
    }

    @Override
    protected void initGUI() {
        if (this.m_LayoutType == null) {
            return;
        }
        super.initGUI();
        int size = this.m_LayoutType == LayoutType.VERTICAL ? 10 : 20;
        this.m_TextSearch = new JTextField(size);
        this.m_TextSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SearchPanel.this.m_ButtonSearch != null) {
                    SearchPanel.this.m_ButtonSearch.setEnabled(SearchPanel.this.isValidSearch());
                }
                if (!SearchPanel.this.m_Incremental && e.getKeyCode() == 10) {
                    e.consume();
                    SearchPanel.this.performSearch();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.m_TextSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.search();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.search();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.search();
            }

            protected void search() {
                if (SearchPanel.this.m_Incremental) {
                    if (SearchPanel.this.m_TextSearch.getText().length() >= SearchPanel.this.m_MinimumChars) {
                        SearchPanel.this.performSearch();
                    } else {
                        SearchPanel.this.clearSearch();
                    }
                }
            }
        });
        if (this.hasPrefix()) {
            char mnemonic = GUIHelper.getMnemonic(this.m_Prefix);
            String caption = GUIHelper.stripMnemonic(this.m_Prefix);
            this.m_LabelPrefix = new JLabel(caption);
            this.m_LabelPrefix.setLabelFor(this.m_TextSearch);
            if (mnemonic != '\u0000') {
                this.m_LabelPrefix.setDisplayedMnemonic(mnemonic);
            } else {
                this.m_LabelPrefix.setDisplayedMnemonicIndex(-1);
            }
        }
        this.m_CheckboxRegExp = new JCheckBox("Use reg. Exp");
        if (this.m_ButtonCaption != null) {
            this.m_ButtonSearch = new JButton();
            this.setButtonCaption(this.m_ButtonCaption);
            this.m_ButtonSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.performSearch();
                }
            });
        }
        this.m_PanelWidgets = new JPanel();
        this.add((Component)this.m_PanelWidgets, "North");
        if (this.m_LayoutType == LayoutType.HORIZONTAL) {
            this.m_LayoutWidgets = null;
            this.m_PanelWidgets.setLayout(new FlowLayout(0));
        } else if (this.m_LayoutType == LayoutType.VERTICAL) {
            this.m_LayoutWidgets = new GridLayout(0, 1, 0, 2);
            this.m_PanelWidgets.setLayout(this.m_LayoutWidgets);
        } else {
            throw new IllegalStateException("Unhandled layout type '" + (Object)((Object)this.m_LayoutType) + "'!");
        }
        if (this.hasPrefix()) {
            this.addToWidgetsPanel(this.m_LabelPrefix);
        }
        this.addToWidgetsPanel(this.m_TextSearch);
        if (this.isRegularExpressionEnabled()) {
            this.addToWidgetsPanel(this.m_CheckboxRegExp);
        }
        if (this.m_ButtonSearch != null) {
            this.addToWidgetsPanel(this.m_ButtonSearch);
        }
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.hasPrefix()) {
            this.m_LabelPrefix.setEnabled(value);
        }
        this.m_TextSearch.setEnabled(value);
        this.m_CheckboxRegExp.setEnabled(value);
        if (this.m_ButtonSearch != null) {
            this.m_ButtonSearch.setEnabled(value);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_TextSearch.isEditable();
    }

    public LayoutType getLayoutType() {
        return this.m_LayoutType;
    }

    protected boolean hasPrefix() {
        return this.m_Prefix != null;
    }

    public boolean isRegularExpressionEnabled() {
        return this.m_RegExpEnabled;
    }

    public void setSearchText(String value) {
        this.m_TextSearch.setText(value);
    }

    public String getSearchText() {
        return this.m_TextSearch.getText();
    }

    public void setRegularExpression(boolean value) {
        this.m_CheckboxRegExp.setSelected(value);
    }

    public boolean isRegularExpression() {
        return this.m_RegExpEnabled && this.m_CheckboxRegExp.isSelected();
    }

    public boolean isIncremental() {
        return this.m_Incremental;
    }

    public void setMinimumChars(int value) {
        if (value >= 1) {
            this.m_MinimumChars = value;
        }
    }

    public int getMinimumChars() {
        return this.m_MinimumChars;
    }

    public void setTextColumns(int value) {
        if (value > 0) {
            this.m_TextSearch.setColumns(value);
        } else {
            System.err.println("Number of columns must be >0 (provided: " + value + ")!");
        }
    }

    public int getTextColumns() {
        return this.m_TextSearch.getColumns();
    }

    public void setButtonCaption(String value) {
        if (this.m_ButtonSearch == null) {
            return;
        }
        this.m_ButtonCaption = value;
        this.m_ButtonSearch.setText(GUIHelper.stripMnemonic(this.m_ButtonCaption));
        if (GUIHelper.hasMnemonic(this.m_ButtonCaption)) {
            this.m_ButtonSearch.setMnemonic(GUIHelper.getMnemonic(this.m_ButtonCaption));
        }
    }

    public String getButtonCaption() {
        if (this.m_ButtonSearch == null) {
            return null;
        }
        return this.m_ButtonCaption;
    }

    public void clearWidgetsPanel() {
        this.m_PanelWidgets.removeAll();
    }

    public void addToWidgetsPanel(Component comp, int index) {
        this.removeFromWidgetsPanel(comp);
        if (this.m_LayoutWidgets != null) {
            this.m_LayoutWidgets.setRows(this.m_LayoutWidgets.getRows() + 1);
        }
        if (index != -1) {
            this.m_PanelWidgets.add(comp, index);
        } else {
            this.m_PanelWidgets.add(comp);
        }
    }

    public void addToWidgetsPanel(Component comp) {
        this.addToWidgetsPanel(comp, -1);
    }

    public void removeFromWidgetsPanel(Component comp) {
        if (this.m_LayoutWidgets != null) {
            this.m_LayoutWidgets.setRows(this.m_LayoutWidgets.getRows() - 1);
        }
        this.m_PanelWidgets.remove(comp);
    }

    public void addSearchListener(SearchListener l) {
        this.m_SearchListeners.add(l);
    }

    public void removeSearchListener(SearchListener l) {
        this.m_SearchListeners.remove(l);
    }

    protected void notifySearchListeners(SearchEvent e) {
        Iterator<SearchListener> iter = this.m_SearchListeners.iterator();
        while (iter.hasNext()) {
            iter.next().searchInitiated(e);
        }
    }

    protected void performSearch() {
        if (!this.isValidSearch()) {
            return;
        }
        this.m_LastSearch = this.getSearchText();
        this.notifySearchListeners(new SearchEvent(this, this.getSearchText(), this.isRegularExpression()));
    }

    protected void clearSearch() {
        if (this.m_LastSearch.length() > 0) {
            this.m_LastSearch = "";
            this.notifySearchListeners(new SearchEvent(this, "", this.isRegularExpression()));
        }
    }

    protected boolean isValidSearch() {
        if (this.getSearchText().length() == 0) {
            return true;
        }
        if (!this.isRegularExpression()) {
            return true;
        }
        try {
            Pattern.compile(this.getSearchText());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void search() {
        this.performSearch();
    }

    @Override
    public void grabFocus() {
        this.m_TextSearch.grabFocus();
    }

    public void updateWidth(int width) {
        if (this.getLayoutType() != LayoutType.VERTICAL) {
            return;
        }
        this.setSize(width, this.getHeight());
    }

    public static enum LayoutType {
        HORIZONTAL,
        VERTICAL;

    }
}

