/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.option.AbstractOption;
import adams.gui.core.AbstractScript;
import adams.gui.core.StyledTextEditorPanel;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AbstractScriptEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected StyledTextEditorPanel m_TextStatement;

    public static String toString(AbstractOption option, Object object) {
        return ((AbstractScript)object).stringValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        AbstractScript result;
        try {
            Class<?> cls = option.getDefaultValue().getClass();
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            result = (AbstractScript)cls.newInstance();
            result.setValue(Utils.unbackQuoteChars(str));
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return AbstractScriptEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return AbstractScriptEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + AbstractScriptEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : AbstractScriptEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setSize(new Dimension(400, 300));
        panelAll.setMinimumSize(new Dimension(400, 300));
        panelAll.setPreferredSize(new Dimension(400, 300));
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextStatement = this.getValue() == null ? new StyledTextEditorPanel() : ((AbstractScript)this.getValue()).getTextEditorPanel();
        panelAll.add((Component)this.m_TextStatement, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = AbstractScriptEditor.this.m_TextStatement.getContent();
                if (((AbstractScript)AbstractScriptEditor.this.getValue()).isValid(s) && !s.equals(((AbstractScript)AbstractScriptEditor.this.getValue()).getValue())) {
                    try {
                        AbstractScript newValue = (AbstractScript)AbstractScriptEditor.this.getValue().getClass().newInstance();
                        newValue.setValue(s);
                        AbstractScriptEditor.this.setValue(newValue);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to create AbstractScript-derived object from '" + s + "':");
                        ex.printStackTrace();
                    }
                }
                AbstractScriptEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    @Override
    protected void initForDisplay() {
        if (!this.m_TextStatement.getContent().equals("" + this.getValue())) {
            this.m_TextStatement.setContent("" + this.getValue());
        }
        this.m_TextStatement.setToolTipText(((BaseObject)this.getValue()).getTipText());
    }
}

