/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.core.MouseUtils;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.axis.AbsoluteAxisModel;
import adams.gui.visualization.core.axis.AbstractAxisModel;
import adams.gui.visualization.core.axis.Direction;
import adams.gui.visualization.core.axis.Orientation;
import adams.gui.visualization.core.axis.Tick;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisPanel
extends JPanel {
    private static final long serialVersionUID = 5811111621680835988L;
    protected AxisPanel m_Self = this;
    protected Direction m_Direction;
    protected Orientation m_Orientation;
    protected Type m_Type;
    protected Color m_AxisColor;
    protected int m_AxisWidth;
    protected String m_AxisName;
    protected Font m_AxisNameFont;
    protected boolean m_AxisNameCentered;
    protected int m_LengthTicks;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected AbstractAxisModel m_Model;
    protected Hashtable<Type, String> m_NumberFormatOverride;
    protected boolean m_ShowGridLines;
    protected boolean m_ShowOnlyMajorGridLines;
    protected Visibility m_Visibility;

    public AxisPanel(Direction direction, Orientation orientation, Type type) {
        this(direction, orientation, type, 10);
    }

    public AxisPanel(Direction direction, Orientation orientation, Type type, int ticks) {
        this.m_Direction = direction;
        this.m_Orientation = orientation;
        this.m_AxisColor = Color.BLACK;
        this.m_AxisWidth = 20;
        this.m_AxisName = null;
        this.m_AxisNameFont = new Font("Monospaced", 1, 10);
        this.m_AxisNameCentered = false;
        this.m_LengthTicks = 6;
        this.m_PopupMenuCustomizer = null;
        this.m_ChangeListeners = new HashSet();
        this.m_NumberFormatOverride = new Hashtable();
        this.m_ShowGridLines = false;
        this.m_ShowOnlyMajorGridLines = false;
        this.m_Visibility = Visibility.VISIBLE;
        this.m_Model = new AbsoluteAxisModel();
        this.m_Model.setParent(this);
        this.setToolTipText("Right-click for menu");
        this.setType(type);
        this.setMinimum(0.0);
        this.setMaximum(1.0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = AxisPanel.this.getPopupMenu(e);
                    menu.show(AxisPanel.this.m_Self, e.getX(), e.getY());
                }
            }
        });
        this.calculateDimensions();
        this.repaint();
    }

    public String valueToDisplay(double value) {
        return this.m_Model.valueToDisplay(value);
    }

    protected void calculateDimensions() {
        Dimension size = this.m_Direction == Direction.VERTICAL ? new Dimension(this.getActualAxisWidth(), Integer.MAX_VALUE) : new Dimension(Integer.MAX_VALUE, this.getActualAxisWidth());
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public void setDirection(Direction value) {
        this.m_Direction = value;
        this.calculateDimensions();
    }

    public Direction getDirection() {
        return this.m_Direction;
    }

    public void setOrientation(Orientation value) {
        this.m_Orientation = value;
        this.repaint();
    }

    public Orientation getOrientation() {
        return this.m_Orientation;
    }

    public void setType(Type value) {
        this.m_Type = value;
        AbstractAxisModel oldModel = this.m_Model;
        this.m_Model = this.m_Type.getModel();
        this.m_Model.assign(oldModel);
        if (this.hasNumberFormatOverride(this.m_Type)) {
            this.m_Model.setNumberFormat(this.getNumberFormatOverride(this.m_Type));
        }
        this.notifyChangeListeners();
    }

    public Type getType() {
        return this.m_Type;
    }

    public void setAxisColor(Color value) {
        this.m_AxisColor = value;
        this.repaint();
    }

    public Color getAxisColor() {
        return this.m_AxisColor;
    }

    public void setNthValueToShow(int value) {
        this.m_Model.setNthValueToShow(value);
    }

    public int getNthValueToShow() {
        return this.m_Model.getNthValueToShow();
    }

    public void setNumTicks(int value) {
        this.m_Model.setNumTicks(value);
    }

    public int getNumTicks() {
        return this.m_Model.getNumTicks();
    }

    public void setLengthTicks(int value) {
        if (value >= 4) {
            this.m_LengthTicks = value;
            this.repaint();
        } else {
            System.err.println("Ticks must be at least 4 pixels long (provided: " + value + ")!");
        }
    }

    public int getLengthTicks() {
        return this.m_LengthTicks;
    }

    public void setAxisWidth(int value) {
        if (value >= 5) {
            this.m_AxisWidth = value;
            this.calculateDimensions();
        } else {
            System.err.println("Axis width must be at least 5 pixels (provided: " + value + ")!");
        }
    }

    public int getAxisWidth() {
        return this.m_AxisWidth;
    }

    public int getActualAxisWidth() {
        if (this.m_Visibility == Visibility.VISIBLE) {
            return this.m_AxisWidth;
        }
        return 0;
    }

    public void setAxisName(String value) {
        this.m_AxisName = value;
        this.repaint();
    }

    public String getAxisName() {
        return this.m_AxisName;
    }

    public void setAxisNameFont(Font value) {
        this.m_AxisNameFont = value;
    }

    public Font getAxisNameFont() {
        return this.m_AxisNameFont;
    }

    public void setAxisNameCentered(boolean value) {
        this.m_AxisNameCentered = value;
    }

    public boolean isAxisNameCentered() {
        return this.m_AxisNameCentered;
    }

    public void setMinimum(double value) {
        this.m_Model.setMinimum(value);
    }

    public double getMinimum() {
        return this.m_Model.getMinimum();
    }

    public void setMaximum(double value) {
        this.m_Model.setMaximum(value);
    }

    public double getMaximum() {
        return this.m_Model.getMaximum();
    }

    public void setTopMargin(double value) {
        this.m_Model.setTopMargin(value);
    }

    public double getTopMargin() {
        return this.m_Model.getTopMargin();
    }

    public void setBottomMargin(double value) {
        this.m_Model.setBottomMargin(value);
    }

    public double getBottomMargin() {
        return this.m_Model.getBottomMargin();
    }

    public void clearPanning() {
        this.m_Model.setPixelOffset(0);
    }

    public void setPixelOffset(int value) {
        this.m_Model.setPixelOffset(value);
    }

    public int getPixelOffset() {
        return this.m_Model.getPixelOffset();
    }

    public void setNumberFormat(String value) {
        this.m_Model.setNumberFormat(value);
        this.notifyChangeListeners();
    }

    public String getNumberFormat() {
        return this.m_Model.getNumberFormat();
    }

    public void setShowGridLines(boolean value) {
        this.m_ShowGridLines = value;
        this.notifyChangeListeners();
    }

    public boolean getShowGridLines() {
        return this.m_ShowGridLines;
    }

    public void setShowOnlyMajorGridLines(boolean value) {
        this.m_ShowOnlyMajorGridLines = value;
        this.notifyChangeListeners();
    }

    public boolean getShowOnlyMajorGridLines() {
        return this.m_ShowOnlyMajorGridLines;
    }

    public AbstractAxisModel getAxisModel() {
        return this.m_Model;
    }

    public void setVisibility(Visibility value) {
        this.m_Visibility = value;
        this.calculateDimensions();
        this.notifyChangeListeners();
    }

    public Visibility getVisibility() {
        return this.m_Visibility;
    }

    public void pushZoom(double min, double max) {
        this.m_Model.pushZoom(min, max);
    }

    public void popZoom() {
        this.m_Model.popZoom();
    }

    public boolean isZoomed() {
        return this.m_Model.isZoomed();
    }

    public void clearZoom() {
        this.m_Model.clearZoom();
    }

    public int getLength() {
        if (this.m_Direction == Direction.HORIZONTAL) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    public JPopupMenu getPopupMenu(MouseEvent e) {
        JMenuItem item;
        JPopupMenu result = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        Type[] arr$ = Type.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Type t;
            final Type type = t = arr$[i$];
            item = new JRadioButtonMenuItem(t.toString());
            if (this.m_Type == t) {
                item.setSelected(true);
            }
            item.setEnabled(t.canHandle(this.m_Model.getMinimum(), this.m_Model.getMaximum()));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxisPanel.this.m_Self.setType(type);
                }
            });
            if (!item.isSelected() && !item.isEnabled()) continue;
            result.add(item);
            group.add(item);
        }
        result.addSeparator();
        item = new JMenuItem("Format...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pattern = AxisPanel.this.getNumberFormat();
                if ((pattern = JOptionPane.showInputDialog(AxisPanel.this.m_Self, "Please enter format (empty format resets to default again):", pattern)) != null) {
                    if (pattern.length() == 0) {
                        AxisPanel.this.removeNumberFormatOverride(AxisPanel.this.getType());
                    } else {
                        AxisPanel.this.addNumberFormatOverride(AxisPanel.this.getType(), pattern);
                    }
                }
            }
        });
        result.add(item);
        item = new JCheckBoxMenuItem("Grid lines");
        item.setSelected(this.getShowGridLines());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisPanel.this.setShowGridLines(!AxisPanel.this.getShowGridLines());
            }
        });
        result.add(item);
        item = new JCheckBoxMenuItem("Only major grid lines");
        item.setSelected(this.getShowOnlyMajorGridLines());
        item.setEnabled(this.getShowGridLines());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisPanel.this.setShowOnlyMajorGridLines(!AxisPanel.this.getShowOnlyMajorGridLines());
            }
        });
        result.add(item);
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(e, result);
        }
        return result;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        final ChangeEvent e = new ChangeEvent(this);
        for (final ChangeListener l : this.m_ChangeListeners) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    l.stateChanged(e);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addNumberFormatOverride(Type type, String format) {
        this.m_NumberFormatOverride.put(type, format);
        if (this.getType() == type) {
            this.setNumberFormat(format);
        }
    }

    public void removeNumberFormatOverride(Type type) {
        this.m_NumberFormatOverride.remove(type);
        if (this.getType() == type) {
            this.setNumberFormat(type.getModel().getNumberFormat());
        }
    }

    public boolean hasNumberFormatOverride(Type type) {
        return this.m_NumberFormatOverride.containsKey(type);
    }

    public String getNumberFormatOverride(Type type) {
        return this.m_NumberFormatOverride.get(type);
    }

    public int correctPosition(int pos) {
        int result = pos;
        if (this.m_Direction == Direction.VERTICAL) {
            result = this.getLength() - 1 - result;
        }
        return result;
    }

    public int valueToPos(double value) {
        int result = this.m_Model.valueToPos(value);
        result = this.correctPosition(result);
        return result;
    }

    public double posToValue(int pos) {
        pos = this.correctPosition(pos);
        double result = this.m_Model.posToValue(pos);
        return result;
    }

    public void drawBar(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int height = this.getSize().height;
        int width = this.getSize().width;
        g.setColor(this.m_AxisColor);
        if (this.m_Direction == Direction.VERTICAL) {
            if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
                g.drawLine(width - 1, 0, width - 1, height);
            } else {
                g.drawLine(0, 0, 0, height - 1);
            }
        } else if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
            g.drawLine(0, 0, width - 1, 0);
        } else {
            g2d.drawLine(0, height - 1, width - 1, height - 1);
        }
    }

    protected void drawTicks(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int height = this.getSize().height;
        int width = this.getSize().width;
        Vector<Tick> ticks = this.m_Model.getTicks();
        g.setColor(this.m_AxisColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.m_Direction == Direction.VERTICAL) {
            if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
                for (int i = 0; i < ticks.size(); ++i) {
                    Tick tick = ticks.get(i);
                    int tickPos = this.correctPosition(tick.getPosition());
                    int len = tick.hasLabel() ? this.m_LengthTicks : this.m_LengthTicks / 2;
                    g.drawLine(width - len, tickPos, width, tickPos);
                    if (!tick.hasLabel()) continue;
                    TextLayout textLayoutValue = new TextLayout(tick.getLabel(), g.getFont(), g2d.getFontRenderContext());
                    Rectangle2D textBoundsValue = textLayoutValue.getBounds();
                    int y = tickPos;
                    if (i == 0) {
                        y = (int)((double)y - textBoundsValue.getHeight() / 2.0);
                    }
                    if (i == ticks.size() - 1 && tick.getPosition() == height - 1) {
                        y = (int)((double)y + (textBoundsValue.getHeight() / 2.0 + 2.0));
                    }
                    y = (int)((double)y + textBoundsValue.getHeight() / 2.0);
                    int x = (int)((double)width - (textBoundsValue.getWidth() + (double)this.m_LengthTicks + 4.0));
                    g.drawString(tick.getLabel(), x, y);
                }
            } else {
                for (int i = 0; i < ticks.size(); ++i) {
                    Tick tick = ticks.get(i);
                    int tickPos = this.correctPosition(tick.getPosition());
                    int len = tick.hasLabel() ? this.m_LengthTicks : this.m_LengthTicks / 2;
                    g.drawLine(0, tickPos, len, tickPos);
                    if (!tick.hasLabel()) continue;
                    TextLayout textLayoutValue = new TextLayout(tick.getLabel(), g.getFont(), g2d.getFontRenderContext());
                    Rectangle2D textBoundsValue = textLayoutValue.getBounds();
                    int y = tickPos;
                    if (i == 0) {
                        y = (int)((double)y - textBoundsValue.getHeight() / 2.0);
                    }
                    if (i == ticks.size() - 1 && tick.getPosition() == height - 1) {
                        y = (int)((double)y + (textBoundsValue.getHeight() / 2.0 + 2.0));
                    }
                    y = (int)((double)y + textBoundsValue.getHeight() / 2.0);
                    int x = this.m_LengthTicks + 4;
                    g.drawString(tick.getLabel(), x, y);
                }
            }
        } else if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
            for (int i = 0; i < ticks.size(); ++i) {
                Tick tick = ticks.get(i);
                int tickPos = this.correctPosition(tick.getPosition());
                int len = tick.hasLabel() ? this.m_LengthTicks : this.m_LengthTicks / 2;
                g.drawLine(tickPos, 0, tickPos, len);
                if (!tick.hasLabel()) continue;
                TextLayout textLayoutValue = new TextLayout(tick.getLabel(), g.getFont(), g2d.getFontRenderContext());
                Rectangle2D textBoundsValue = textLayoutValue.getBounds();
                int x = tickPos;
                if (i == 0) {
                    x = (int)((double)x + textBoundsValue.getWidth() / 2.0);
                }
                if (i == ticks.size() - 1 && tick.getPosition() == width - 1) {
                    x = (int)((double)x - textBoundsValue.getWidth() / 2.0);
                }
                x = (int)((double)x - textBoundsValue.getWidth() / 2.0);
                int y = (int)(textBoundsValue.getHeight() + (double)this.m_LengthTicks + 4.0);
                g.drawString(tick.getLabel(), x, y);
            }
        } else {
            for (int i = 0; i < ticks.size(); ++i) {
                Tick tick = ticks.get(i);
                int tickPos = this.correctPosition(tick.getPosition());
                int len = tick.hasLabel() ? this.m_LengthTicks : this.m_LengthTicks / 2;
                g2d.drawLine(tickPos, height - len - 1, tickPos, height);
                if (!tick.hasLabel()) continue;
                TextLayout textLayoutValue = new TextLayout(tick.getLabel(), g.getFont(), g2d.getFontRenderContext());
                Rectangle2D textBoundsValue = textLayoutValue.getBounds();
                int x = tickPos;
                if (i == 0) {
                    x = (int)((double)x + textBoundsValue.getWidth() / 2.0);
                }
                if (i == ticks.size() - 1 && tick.getPosition() == width - 1) {
                    x = (int)((double)x - textBoundsValue.getWidth() / 2.0);
                }
                x = (int)((double)x - textBoundsValue.getWidth() / 2.0);
                int y = height - (this.m_LengthTicks + 4);
                g.drawString(tick.getLabel(), x, y);
            }
        }
    }

    protected void drawName(Graphics g) {
        RectangularShape textBoundsName;
        Graphics2D g2d = (Graphics2D)g;
        int height = this.getSize().height;
        int width = this.getSize().width;
        Font defaultFont = g.getFont();
        if (this.m_AxisName != null && this.m_AxisName.length() > 0) {
            TextLayout textLayoutName = new TextLayout(this.m_AxisName, this.m_AxisNameFont, g2d.getFontRenderContext());
            textBoundsName = textLayoutName.getBounds();
        } else {
            Object textLayoutName = null;
            textBoundsName = null;
        }
        if (this.m_Direction == Direction.VERTICAL) {
            if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
                g2d.rotate(4.71238898038469);
                int x = (int)(-(((double)height - textBoundsName.getWidth()) / 2.0 + textBoundsName.getWidth()));
                int y = this.m_AxisNameCentered ? (int)(textBoundsName.getHeight() / 2.0 + (double)((width - this.m_LengthTicks) / 2)) : (int)(textBoundsName.getHeight() + 6.0);
                g.setColor(this.getBackground());
                g.setFont(this.m_AxisNameFont);
                g.fillRect((int)Math.round(textBoundsName.getX() + (double)x) - 2, (int)Math.round(textBoundsName.getY() + (double)y) - 2, (int)Math.round(textBoundsName.getWidth()) + 4, (int)Math.round(textBoundsName.getHeight()) + 4);
                g.setColor(this.m_AxisColor);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.drawString(this.m_AxisName, x, y);
                g.setFont(defaultFont);
                g2d.rotate(0.0);
            } else {
                g2d.rotate(1.5707963267948966);
                int x = (int)(((double)height - textBoundsName.getWidth()) / 2.0);
                int y = this.m_AxisNameCentered ? -(width / 2) + this.m_LengthTicks : (int)(-((double)width - textBoundsName.getHeight() - 4.0));
                g.setColor(this.getBackground());
                g.setFont(this.m_AxisNameFont);
                g.fillRect((int)Math.round(textBoundsName.getX() + (double)x) - 2, (int)Math.round(textBoundsName.getY() + (double)y) - 2, (int)Math.round(textBoundsName.getWidth()) + 4, (int)Math.round(textBoundsName.getHeight()) + 4);
                g.setColor(this.m_AxisColor);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.drawString(this.m_AxisName, x, y);
                g.setFont(defaultFont);
                g2d.rotate(0.0);
            }
        } else if (this.m_Orientation == Orientation.LEFT_TO_RIGHT) {
            int x = (int)(((double)width - textBoundsName.getWidth()) / 2.0);
            int y = this.m_AxisNameCentered ? height / 2 + this.m_LengthTicks : (int)((double)height - textBoundsName.getHeight());
            g.setColor(this.getBackground());
            g.setFont(this.m_AxisNameFont);
            g.fillRect((int)Math.round(textBoundsName.getX() + (double)x) - 2, (int)Math.round(textBoundsName.getY() + (double)y) - 2, (int)Math.round(textBoundsName.getWidth()) + 4, (int)Math.round(textBoundsName.getHeight()) + 4);
            g.setColor(this.m_AxisColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(this.m_AxisName, x, y);
            g.setFont(defaultFont);
        } else {
            int x = (int)(((double)width - textBoundsName.getWidth()) / 2.0);
            int y = this.m_AxisNameCentered ? height / 2 + this.m_LengthTicks : (int)(textBoundsName.getHeight() + 4.0);
            g.setColor(this.getBackground());
            g.setFont(this.m_AxisNameFont);
            g.fillRect((int)Math.round(textBoundsName.getX() + (double)x) - 2, (int)Math.round(textBoundsName.getY() + (double)y) - 2, (int)Math.round(textBoundsName.getWidth()) + 4, (int)Math.round(textBoundsName.getHeight()) + 4);
            g.setColor(this.m_AxisColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(this.m_AxisName, x, y);
            g.setFont(defaultFont);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.m_Model.validate();
        this.drawBar(g);
        this.drawTicks(g);
        if (this.m_AxisName != null) {
            this.drawName(g);
        }
    }

    @Override
    public String toString() {
        String result = this.getClass().getName() + ": ";
        result = result + "name=" + this.m_AxisName + ", ";
        result = result + "direction=" + (Object)((Object)this.m_Direction) + ", ";
        result = result + "orientation=" + (Object)((Object)this.m_Orientation) + ", ";
        result = result + "visibility=" + (Object)((Object)this.m_Visibility) + ", ";
        result = result + "act.width=" + this.getActualAxisWidth() + ", ";
        result = result + "panel.width=" + (this.m_Direction == Direction.HORIZONTAL ? this.getPreferredSize().height : this.getPreferredSize().width) + ", ";
        result = result + "type=" + this.m_Type + ", ";
        result = result + "model=[" + this.m_Model + "]";
        return result;
    }
}

