/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.parser.AbstractSymbolEvaluator;
import adams.parser.booleanexpression.Parser;
import adams.parser.booleanexpression.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class BooleanExpression
extends AbstractSymbolEvaluator<Boolean> {
    private static final long serialVersionUID = -5923987640355752595L;

    @Override
    public String globalInfo() {
        return "Evaluates boolean expressions.\n\nIt uses the following grammar:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return " expr_list ::= expr_list expr_part | expr_part ;\n expr_part ::= boolexpr ;\n\n boolexpr ::=    ( boolexpr )\n               | true\n               | false\n               | numexpr < numexpr\n               | numexpr <= numexpr\n               | numexpr > numexpr\n               | numexpr >= numexpr\n               | numexpr = numexpr\n               | numexpr != numexpr\n               | strexpr < strexpr\n               | strexpr <= strexpr\n               | strexpr > strexpr\n               | strexpr >= strexpr\n               | strexpr = strexpr\n               | strexpr != strexpr\n               | matches ( strexpr , regexp )\n               | ! boolexpr\n               | boolexpr & boolexpr\n               | boolexpr | boolexpr\n               ;\n\n numexpr   ::=   ( numexpr )\n               | NUMBER\n               | -numexpr\n               | constexpr\n               | opexpr\n               | varexpr\n               | funcexpr\n               ;\n\n strexpr   ::=   substr ( strexpr , start )\n               | substr ( strexpr , start , end )\n               | lowercase ( strexpr )\n               | uppercase ( strexpr )\n               | string\n               ;\n\n constexpr ::=   PI\n               | E\n               ;\n\n opexpr    ::=   numexpr + numexpr\n               | numexpr - numexpr\n               | numexpr * numexpr\n               | numexpr / numexpr\n               | numexpr ^ numexpr\n               ;\n\n varexpr  ::=  VARIABLE ;\n\n funcexpr ::=    abs ( numexpr )\n               | sqrt ( numexpr )\n               | log ( numexpr )\n               | exp ( numexpr )\n               | sin ( numexpr )\n               | cos ( numexpr )\n               | tan ( numexpr )\n               | rint ( numexpr )\n               | floor ( numexpr )\n               | pow ( numexpr , numexpr )\n               | ceil ( numexpr )\n               | ifelse ( boolexpr , numexpr (if true) , numexpr (if false) )\n               | length ( str )\n               ;\n\nNotes:\n- 'start' and 'end' for function 'substr' are indices that start at 1.\n- index 'end' for function 'substr' is excluded (like Java's 'String.substring(int,int)' method)\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "true";
    }

    @Override
    public String expressionTipText() {
        return "The boolean expression to evaluate (must evaluate to a boolean).";
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getSystemErr().println("Failed to parse the value of symbol '" + name + "': " + value);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    protected Boolean doEvaluate(HashMap symbols) throws Exception {
        return BooleanExpression.evaluate(this.m_Expression, symbols);
    }

    public static boolean evaluate(String expr, HashMap symbols) throws Exception {
        if (expr.equals("true")) {
            return true;
        }
        if (expr.equals("false")) {
            return false;
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        BooleanExpression.runEvaluator(BooleanExpression.class, args);
    }
}

