/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.parser.AbstractExpressionEvaluator;
import adams.parser.MathematicalExpression;
import java.util.HashMap;
import java.util.Vector;

public class ReportMathExpression
extends AbstractExpressionEvaluator<Double> {
    private static final long serialVersionUID = 8014316012335802585L;
    protected Report m_Report;

    @Override
    public String globalInfo() {
        return "Evaluates mathematical expressions on report values.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Report = new Report();
    }

    @Override
    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    @Override
    protected String getDefaultExpression() {
        return "42";
    }

    @Override
    public String expressionTipText() {
        return "The mathematical expression, including report fields, to evaluate (must evaluate to a double).";
    }

    public void setReport(Report value) {
        this.m_Report = value;
    }

    public Report getReport() {
        return this.m_Report;
    }

    @Override
    public Double evaluate() throws Exception {
        return ReportMathExpression.evaluate(this.m_Expression, this.m_Report);
    }

    public static double evaluate(String expr, Report report) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Vector<AbstractField> fields = report.getFields();
        block4: for (AbstractField field : fields) {
            switch (field.getDataType()) {
                case NUMERIC: {
                    values.put(field.toString(), report.getDoubleValue(field));
                    continue block4;
                }
                case BOOLEAN: {
                    values.put(field.toString(), report.getBooleanValue(field));
                    continue block4;
                }
            }
            values.put(field.toString(), "" + report.getValue(field));
        }
        return MathematicalExpression.evaluate(expr, values);
    }

    public static void main(String[] args) {
        ReportMathExpression.runEvaluator(ReportMathExpression.class, args);
    }
}

