/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.evaluator;

import adams.data.weka.evaluator.AbstractInstanceEvaluator;
import weka.core.Instance;

public class NamedSetup
extends AbstractInstanceEvaluator {
    private static final long serialVersionUID = 4379805017266122486L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractInstanceEvaluator m_ActualScheme;

    public String globalInfo() {
        return "Applies an evaluator that is referenced via its global setup name (see 'NamedSetups').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getSystemErr().println("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractInstanceEvaluator getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractInstanceEvaluator)((Object)this.m_Setup.getSetup());
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    @Override
    protected double doEvaluate(Instance inst) {
        return this.getActualScheme().evaluate(inst);
    }
}

