/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontMap;
import de.intarsys.cwt.font.IFont;
import java.util.HashMap;
import java.util.Map;

public class FontMapper {
    private static FontMapper Active = new FontMapper();
    private Map<String, FontMap> fontMaps = new HashMap<String, FontMap>();

    public static synchronized FontMapper get() {
        return Active;
    }

    public static synchronized void set(FontMapper mapper) {
        Active = mapper;
    }

    protected FontMapper() {
    }

    public IFont lookupFont(String name) {
        FontMap fontMap = this.fontMaps.get(this.normalize(name));
        if (fontMap == null) {
            return null;
        }
        return fontMap.getFont();
    }

    protected String normalize(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    public void registerFontMap(FontMap map) {
        this.fontMaps.put(this.normalize(map.getKey()), map);
    }
}

