/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.history;

import java.text.MessageFormat;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTriggerHistoryPlugin
implements SchedulerPlugin,
TriggerListener {
    private String name;
    private String triggerFiredMessage = "Trigger {1}.{0} fired job {6}.{5} at: {4, date, HH:mm:ss MM/dd/yyyy}";
    private String triggerMisfiredMessage = "Trigger {1}.{0} misfired job {6}.{5}  at: {4, date, HH:mm:ss MM/dd/yyyy}.  Should have fired at: {3, date, HH:mm:ss MM/dd/yyyy}";
    private String triggerCompleteMessage = "Trigger {1}.{0} completed firing job {6}.{5} at {4, date, HH:mm:ss MM/dd/yyyy} with resulting trigger instruction code: {9}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    public String getTriggerCompleteMessage() {
        return this.triggerCompleteMessage;
    }

    public String getTriggerFiredMessage() {
        return this.triggerFiredMessage;
    }

    public String getTriggerMisfiredMessage() {
        return this.triggerMisfiredMessage;
    }

    public void setTriggerCompleteMessage(String triggerCompleteMessage) {
        this.triggerCompleteMessage = triggerCompleteMessage;
    }

    public void setTriggerFiredMessage(String triggerFiredMessage) {
        this.triggerFiredMessage = triggerFiredMessage;
    }

    public void setTriggerMisfiredMessage(String triggerMisfiredMessage) {
        this.triggerMisfiredMessage = triggerMisfiredMessage;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        scheduler.addGlobalTriggerListener(this);
    }

    public void start() {
    }

    public void shutdown() {
    }

    public String getName() {
        return this.name;
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Object[] args = new Object[]{trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Integer(context.getRefireCount())};
        this.getLog().info(MessageFormat.format(this.getTriggerFiredMessage(), args));
    }

    public void triggerMisfired(Trigger trigger) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Object[] args = new Object[]{trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), trigger.getJobName(), trigger.getJobGroup()};
        this.getLog().info(MessageFormat.format(this.getTriggerMisfiredMessage(), args));
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        String instrCode = "UNKNOWN";
        if (triggerInstructionCode == 3) {
            instrCode = "DELETE TRIGGER";
        } else if (triggerInstructionCode == 0) {
            instrCode = "DO NOTHING";
        } else if (triggerInstructionCode == 1) {
            instrCode = "RE-EXECUTE JOB";
        } else if (triggerInstructionCode == 4) {
            instrCode = "SET ALL OF JOB'S TRIGGERS COMPLETE";
        } else if (triggerInstructionCode == 2) {
            instrCode = "SET THIS TRIGGER COMPLETE";
        }
        Object[] args = new Object[]{trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Date(), context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Integer(context.getRefireCount()), new Integer(triggerInstructionCode), instrCode};
        this.getLog().info(MessageFormat.format(this.getTriggerCompleteMessage(), args));
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }
}

