/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.MethodVisitor;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.classgen.BytecodeInstruction;
import org.codehaus.groovy.classgen.BytecodeSequence;
import org.codehaus.groovy.classgen.InnerClassVisitorHelper;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;

public class InnerClassCompletionVisitor {
    public void visitClass(ClassNode node) {
        InnerClassNode innerClass = null;
        if (!node.isEnum() && !node.isInterface() && node instanceof InnerClassNode) {
            innerClass = (InnerClassNode)node;
        }
        if (node.isEnum() || node.isInterface()) {
            return;
        }
        this.addDispatcherMethods(node);
        if (innerClass == null) {
            return;
        }
        this.addDefaultMethods(innerClass);
    }

    private String getTypeDescriptor(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getTypeDescription(InnerClassVisitorHelper.getClassNode(node, isStatic));
    }

    private String getInternalName(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getClassInternalName(InnerClassVisitorHelper.getClassNode(node, isStatic));
    }

    private void addDispatcherMethods(ClassNode classNode) {
        int objectDistance = InnerClassVisitorHelper.getObjectDistance(classNode);
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "args")};
        MethodNode method = classNode.addSyntheticMethod("this$dist$invoke$" + objectDistance, 4097, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        BlockStatement block = new BlockStatement();
        InnerClassVisitorHelper.setMethodDispatcherCode(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "value")};
        method = classNode.addSyntheticMethod("this$dist$set$" + objectDistance, 4097, ClassHelper.VOID_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        InnerClassVisitorHelper.setPropertySetterDispatcher(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")};
        method = classNode.addSyntheticMethod("this$dist$get$" + objectDistance, 4097, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        InnerClassVisitorHelper.setPropertyGetterDispatcher(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
    }

    private void addDefaultMethods(InnerClassNode node) {
        boolean isStatic = InnerClassVisitorHelper.isStatic(node);
        ClassNode outerClass = node.getOuterClass();
        final String classInternalName = BytecodeHelper.getClassInternalName(node);
        final String outerClassInternalName = this.getInternalName(outerClass, isStatic);
        final String outerClassDescriptor = this.getTypeDescriptor(outerClass, isStatic);
        final int objectDistance = InnerClassVisitorHelper.getObjectDistance(outerClass);
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "args")};
        MethodNode method = node.addSyntheticMethod("methodMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        BlockStatement block = new BlockStatement();
        if (isStatic) {
            InnerClassVisitorHelper.setMethodDispatcherCode(block, new ClassExpression(outerClass), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$invoke$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "val")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.VOID_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            InnerClassVisitorHelper.setPropertySetterDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$set$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)V");
                    mv.visitInsn(177);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            InnerClassVisitorHelper.setPropertyGetterDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$get$" + objectDistance, "(Ljava/lang/String;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
    }
}

