/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import com.ibm.media.protocol.CloneableSourceStreamAdapter;
import com.ibm.media.protocol.SourceStreamSlave;
import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;

class SuperCloneableDataSource
extends DataSource {
    protected DataSource input;
    public CloneableSourceStreamAdapter[] streamsAdapters;
    public SourceStream[] streams = null;
    private Vector clones = new Vector();

    SuperCloneableDataSource(DataSource input) {
        this.input = input;
        SourceStream[] originalStreams = null;
        if (input instanceof PullDataSource) {
            originalStreams = ((PullDataSource)input).getStreams();
        }
        if (input instanceof PushDataSource) {
            originalStreams = ((PushDataSource)input).getStreams();
        }
        if (input instanceof PullBufferDataSource) {
            originalStreams = ((PullBufferDataSource)input).getStreams();
        }
        if (input instanceof PushBufferDataSource) {
            originalStreams = ((PushBufferDataSource)input).getStreams();
        }
        this.streamsAdapters = new CloneableSourceStreamAdapter[originalStreams.length];
        int i2 = 0;
        while (i2 < originalStreams.length) {
            this.streamsAdapters[i2] = new CloneableSourceStreamAdapter(originalStreams[i2]);
            ++i2;
        }
    }

    DataSource createClone() {
        DataSource newSlave = this.input instanceof PullDataSource || this.input instanceof PushDataSource ? new PushDataSourceSlave() : new PushBufferDataSourceSlave();
        this.clones.addElement(newSlave);
        try {
            newSlave.connect();
        }
        catch (IOException e2) {
            return null;
        }
        return newSlave;
    }

    public String getContentType() {
        return this.input.getContentType();
    }

    public void connect() throws IOException {
        this.input.connect();
    }

    public void disconnect() {
        this.input.disconnect();
    }

    public void start() throws IOException {
        this.input.start();
    }

    public void stop() throws IOException {
        this.input.stop();
    }

    public Object[] getControls() {
        return this.input.getControls();
    }

    public Object getControl(String controlType) {
        return this.input.getControl(controlType);
    }

    public Time getDuration() {
        return this.input.getDuration();
    }

    class PushBufferDataSourceSlave
    extends PushBufferDataSource {
        PushBufferStream[] streams = null;

        public PushBufferDataSourceSlave() {
            this.streams = new PushBufferStream[SuperCloneableDataSource.this.streamsAdapters.length];
            int i2 = 0;
            while (i2 < this.streams.length) {
                this.streams[i2] = (PushBufferStream)SuperCloneableDataSource.this.streamsAdapters[i2].createSlave();
                ++i2;
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
            int i2 = 0;
            while (i2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[i2])).connect();
                ++i2;
            }
        }

        public void disconnect() {
            int i2 = 0;
            while (i2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[i2])).disconnect();
                ++i2;
            }
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }
    }

    class PushDataSourceSlave
    extends PushDataSource {
        PushSourceStream[] streams = null;

        public PushDataSourceSlave() {
            this.streams = new PushSourceStream[SuperCloneableDataSource.this.streamsAdapters.length];
            int i2 = 0;
            while (i2 < this.streams.length) {
                this.streams[i2] = (PushSourceStream)SuperCloneableDataSource.this.streamsAdapters[i2].createSlave();
                ++i2;
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
            int i2 = 0;
            while (i2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[i2])).connect();
                ++i2;
            }
        }

        public void disconnect() {
            int i2 = 0;
            while (i2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[i2])).disconnect();
                ++i2;
            }
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushSourceStream[] getStreams() {
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }
    }
}

