/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.BasicPlugIn;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public abstract class BasicPullParser
extends BasicPlugIn
implements Demultiplexer {
    protected DataSource source;
    protected SourceStream[] streams;
    private Format[] outputFormats;
    private byte[] b = new byte[1];
    private byte[] intArray = new byte[4];
    private byte[] shortArray = new byte[2];
    private final int TEMP_BUFFER_LENGTH = 2048;
    private byte[] tempBuffer = new byte[2048];
    private long currentLocation = 0L;
    protected boolean seekable = false;
    protected boolean positionable = false;
    protected CachedStream cacheStream;
    private Object sync = new Object();

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.streams = ((PullDataSource)source).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        this.source = source;
        this.streams = this.streams;
        this.positionable = this.streams[0] instanceof Seekable;
        boolean bl = this.seekable = this.positionable && ((Seekable)((Object)this.streams[0])).isRandomAccess();
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        try {
            this.cacheStream = (CachedStream)((Object)this.streams[0]);
        }
        catch (ClassCastException e2) {
            this.cacheStream = null;
        }
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PullSourceStream;
    }

    public boolean isPositionable() {
        return this.positionable;
    }

    public boolean isRandomAccess() {
        return this.seekable;
    }

    public int readBytes(PullSourceStream pss, byte[] array, int numBytes) throws IOException {
        return this.readBytes(pss, array, 0, numBytes);
    }

    public int readBytes(PullSourceStream pss, byte[] array, int offset, int numBytes) throws IOException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > array.length || numBytes < 0 || offset + numBytes > array.length || offset + numBytes < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (numBytes == 0) {
            return 0;
        }
        int remainingLength = numBytes;
        int actualRead = 0;
        remainingLength = numBytes;
        while (remainingLength > 0) {
            actualRead = pss.read(array, offset, remainingLength);
            if (actualRead == -1) {
                if (offset == 0) {
                    throw new IOException("BasicPullParser: readBytes(): Reached end of stream while trying to read " + numBytes + " bytes");
                }
                return offset;
            }
            if (actualRead == -2) {
                return -2;
            }
            if (actualRead < 0) {
                throw new IOException("BasicPullParser: readBytes() read returned " + actualRead);
            }
            remainingLength -= actualRead;
            offset += actualRead;
            Object object = this.sync;
            synchronized (object) {
                this.currentLocation += (long)actualRead;
            }
        }
        return numBytes;
    }

    public int readInt(PullSourceStream pss) throws IOException {
        return this.readInt(pss, true);
    }

    public int readShort(PullSourceStream pss) throws IOException {
        return this.readShort(pss, true);
    }

    public int readByte(PullSourceStream pss) throws IOException {
        this.readBytes(pss, this.b, 1);
        return this.b[0];
    }

    protected int readInt(PullSourceStream pss, boolean isBigEndian) throws IOException {
        this.readBytes(pss, this.intArray, 4);
        int result = isBigEndian ? (this.intArray[0] & 0xFF) << 24 | (this.intArray[1] & 0xFF) << 16 | (this.intArray[2] & 0xFF) << 8 | this.intArray[3] & 0xFF : (this.intArray[3] & 0xFF) << 24 | (this.intArray[2] & 0xFF) << 16 | (this.intArray[1] & 0xFF) << 8 | this.intArray[0] & 0xFF;
        return result;
    }

    protected int parseIntFromArray(byte[] array, int offset, boolean isBigEndian) throws IOException {
        int result = isBigEndian ? (array[offset + 0] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF : (array[offset + 3] & 0xFF) << 24 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 1] & 0xFF) << 8 | array[offset + 0] & 0xFF;
        return result;
    }

    protected short readShort(PullSourceStream pss, boolean isBigEndian) throws IOException {
        this.readBytes(pss, this.shortArray, 2);
        int result = isBigEndian ? (this.shortArray[0] & 0xFF) << 8 | this.shortArray[1] & 0xFF : (this.shortArray[1] & 0xFF) << 8 | this.shortArray[0] & 0xFF;
        return (short)result;
    }

    public static final short parseShortFromArray(byte[] array, boolean isBigEndian) throws IOException {
        if (array.length < 2) {
            throw new IOException("Unexpected EOF");
        }
        int result = isBigEndian ? (array[0] & 0xFF) << 8 | array[1] & 0xFF : (array[1] & 0xFF) << 8 | array[0] & 0xFF;
        return (short)result;
    }

    protected String readString(PullSourceStream pss) throws IOException {
        this.readBytes(pss, this.intArray, 4);
        return new String(this.intArray);
    }

    public void skip(PullSourceStream pss, int numBytes) throws IOException {
        int bytesRead;
        if (pss instanceof Seekable && ((Seekable)((Object)pss)).isRandomAccess()) {
            long current = ((Seekable)((Object)pss)).tell();
            long newPos = current + (long)numBytes;
            ((Seekable)((Object)pss)).seek(newPos);
            if (newPos != ((Seekable)((Object)pss)).tell()) {
                throw new IOException("Seek to " + newPos + " failed");
            }
            Object object = this.sync;
            synchronized (object) {
                this.currentLocation += (long)numBytes;
            }
            return;
        }
        int remaining = numBytes;
        while (remaining > 2048) {
            bytesRead = this.readBytes(pss, this.tempBuffer, 2048);
            if (bytesRead != 2048) {
                throw new IOException("BasicPullParser: End of Media reached while trying to skip " + numBytes);
            }
            remaining -= 2048;
        }
        if (remaining > 0 && (bytesRead = this.readBytes(pss, this.tempBuffer, remaining)) != remaining) {
            throw new IOException("BasicPullParser: End of Media reached while trying to skip " + numBytes);
        }
        Object object = this.sync;
        synchronized (object) {
            this.currentLocation += (long)numBytes;
        }
    }

    public final long getLocation(PullSourceStream pss) {
        Object object = this.sync;
        synchronized (object) {
            if (pss instanceof Seekable) {
                long l2 = ((Seekable)((Object)pss)).tell();
                return l2;
            }
            long l3 = this.currentLocation;
            return l3;
        }
    }

    public abstract ContentDescriptor[] getSupportedInputContentDescriptors();

    public void open() {
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public void start() throws IOException {
        if (this.source != null) {
            this.source.start();
        }
    }

    public void stop() {
        if (this.source != null) {
            try {
                this.source.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reset() {
    }

    public abstract Time getDuration();

    public abstract Time getMediaTime();

    public abstract Time setPosition(Time var1, int var2);

    public abstract Track[] getTracks() throws IOException, BadHeaderException;
}

