/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SourceRTPPacket;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import javax.media.Buffer;
import javax.media.format.AudioFormat;

public class RTPDemultiplexer {
    private SSRCCache cache;
    private RTPRawReceiver rtpr;
    private Buffer buffer;
    private StreamSynch streamSynch;

    public RTPDemultiplexer(SSRCCache c2, RTPRawReceiver r, StreamSynch streamSynch) {
        this.cache = c2;
        this.rtpr = r;
        this.streamSynch = streamSynch;
        this.buffer = new Buffer();
    }

    public String consumerString() {
        return "RTP DeMultiplexer";
    }

    public void demuxpayload(Packet p) {
        this.demuxpayload((RTPPacket)p);
    }

    public void demuxpayload(SourceRTPPacket sp) {
        SSRCInfo info = sp.ssrcinfo;
        RTPPacket p = sp.p;
        info.payloadType = p.payloadType;
        if (info.dstream != null) {
            this.buffer.setData(p.base.data);
            this.buffer.setFlags(0);
            if (p.marker == 1) {
                this.buffer.setFlags(this.buffer.getFlags() | 0x800);
            }
            this.buffer.setLength(p.payloadlength);
            this.buffer.setOffset(p.payloadoffset);
            if (info.dstream.getFormat() instanceof AudioFormat) {
                long ts = this.streamSynch.calcTimestamp(info.ssrc, p.payloadType, p.timestamp);
                this.buffer.setTimeStamp(ts);
            } else {
                long ts = this.streamSynch.calcTimestamp(info.ssrc, p.payloadType, p.timestamp);
                this.buffer.setTimeStamp(ts);
            }
            this.buffer.setFlags(this.buffer.getFlags() | 0x1000);
            this.buffer.setSequenceNumber(p.seqnum);
            this.buffer.setFormat(info.dstream.getFormat());
            info.dstream.add(this.buffer, info.wrapped, this.rtpr);
        }
    }
}

