/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.print.ODTPrinter;

public class ODTPrinterXML
extends ODTPrinter {
    File f;
    private static final boolean debug = false;

    public ODTPrinterXML(OpenDocument openDocument) {
        super(openDocument);
        String string = openDocument.getZipFile().getName();
        string = string + "p";
        this.f = new File(string);
        if (!this.f.exists()) {
            JOptionPane.showMessageDialog(null, this.f.getAbsolutePath() + " n'existe pas.");
            throw new IllegalStateException("Config file: " + string + " doesn't exist");
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.renderer.getPrintedPagesNumber()) {
            return 1;
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.renderer);
        repaintManager.setDoubleBufferingEnabled(false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        double d = 1.0;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Attribute attribute;
            Cloneable cloneable;
            Cloneable cloneable2;
            Document document = sAXBuilder.build(this.f);
            Element element = document.getRootElement();
            Element element2 = element.getChild("offset");
            if (element2 != null) {
                cloneable2 = element2.getAttribute("x");
                if (cloneable2 != null) {
                    n2 = ((Attribute)cloneable2).getIntValue();
                }
                if ((cloneable = element2.getAttribute("y")) != null) {
                    n3 = ((Attribute)cloneable).getIntValue();
                }
            }
            if ((cloneable2 = element.getChild("center")) != null) {
                cloneable = ((Element)cloneable2).getAttribute("horizontal");
                if (cloneable != null) {
                    bl = ((Attribute)cloneable).getBooleanValue();
                }
                if ((attribute = ((Element)cloneable2).getAttribute("vertical")) != null) {
                    bl2 = attribute.getBooleanValue();
                }
            }
            if ((attribute = ((Element)(cloneable = element.getChild("resize"))).getAttribute("percent")) != null) {
                String string = attribute.getValue();
                d = Double.parseDouble(string = string.replace('%', ' ').trim()) / 100.0;
                if (d <= 0.0 || d > 1.0) {
                    throw new IllegalStateException("Ratio out of bound:" + string + "(should be > 0% and <= 100%");
                }
            }
            double d2 = this.renderer.getPrintWidth();
            double d3 = pageFormat.getImageableWidth();
            double d4 = this.renderer.getPrintHeight();
            double d5 = pageFormat.getImageableHeight();
            System.out.println("Ratio:" + d);
            double d6 = d2 / (d3 * d);
            this.renderer.setIgnoreMargins(true);
            System.err.println("resize factor " + d6);
            this.renderer.setResizeFactor(d6);
            if (bl) {
                n2 = (int)((double)n2 + (d3 - (double)this.renderer.getPrintWidthInPixel()) / 2.0);
            }
            if (bl2) {
                n3 = (int)((double)n3 + (d5 - (double)this.renderer.getPrintHeightInPixel()) / 2.0);
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.translate(n2, n3);
            this.renderer.setCurrentPage(n);
            this.renderer.paintComponent(graphics2D);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }
}

