/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej;

import adams.core.CloneHandler;
import adams.core.Properties;
import adams.data.Notes;
import adams.data.NotesHandler;
import ij.ImagePlus;

public class Image
implements CloneHandler<Image>,
NotesHandler {
    public static final String META_FILENAME = "filename";
    public static final String META_CLASSVALUE = "class-value";
    public static final String META_CLASSTYPE = "class-type";
    protected ImagePlus m_Image;
    protected Properties m_MetaData;
    protected Notes m_Notes = new Notes();

    public Image(ImagePlus img) {
        this(img, new Properties());
    }

    public Image(ImagePlus img, Properties meta) {
        this.setImage(img);
        this.setMetaData(meta);
    }

    public Image getClone() {
        return new Image(new ImagePlus(this.m_Image.getTitle() + "'", this.m_Image.getImage()), this.m_MetaData.getClone());
    }

    public void setImage(ImagePlus value) {
        if (value == null) {
            throw new IllegalArgumentException("Null image provided!");
        }
        this.m_Image = value;
    }

    public ImagePlus getImage() {
        return this.m_Image;
    }

    public void setMetaData(Properties value) {
        this.m_MetaData = value == null ? new Properties() : value.getClone();
    }

    public Properties getMetaData() {
        return this.m_MetaData;
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public String toString() {
        return "img=" + this.m_Image + ", meta=" + this.m_MetaData;
    }
}

