/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.drift;

import java.util.LinkedList;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.core.driftdetection.DriftDetectionMethod;
import moa.classifiers.meta.WEKAClassifier;
import moa.core.Measurement;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.Utils;

public class SingleClassifierDrift
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "bayes.NaiveBayes");
    public ClassOption driftDetectionMethodOption = new ClassOption("driftDetectionMethod", 'd', "Drift detection method to use.", DriftDetectionMethod.class, "DDM");
    protected Classifier classifier;
    protected Classifier newclassifier;
    protected DriftDetectionMethod driftDetectionMethod;
    protected boolean newClassifierReset;
    protected int ddmLevel;
    protected int changeDetected = 0;
    protected int warningDetected = 0;

    public String getPurposeString() {
        return "Classifier that replaces the current classifier with a new one when a change is detected in accuracy.";
    }

    public boolean isWarningDetected() {
        return this.ddmLevel == 1;
    }

    public boolean isChangeDetected() {
        return this.ddmLevel == 2;
    }

    public void resetLearningImpl() {
        this.classifier = ((Classifier)this.getPreparedClassOption(this.baseLearnerOption)).copy();
        this.newclassifier = this.classifier.copy();
        this.classifier.resetLearning();
        this.newclassifier.resetLearning();
        this.driftDetectionMethod = ((DriftDetectionMethod)this.getPreparedClassOption(this.driftDetectionMethodOption)).copy();
        this.newClassifierReset = false;
    }

    public void trainOnInstanceImpl(Instance inst) {
        int trueClass = (int)inst.classValue();
        boolean prediction = Utils.maxIndex((double[])this.classifier.getVotesForInstance(inst)) == trueClass;
        this.ddmLevel = this.driftDetectionMethod.computeNextVal(prediction);
        switch (this.ddmLevel) {
            case 1: {
                ++this.warningDetected;
                if (this.newClassifierReset) {
                    this.newclassifier.resetLearning();
                    this.newClassifierReset = false;
                }
                this.newclassifier.trainOnInstance(inst);
                break;
            }
            case 2: {
                ++this.changeDetected;
                this.classifier = null;
                this.classifier = this.newclassifier;
                if (this.classifier instanceof WEKAClassifier) {
                    ((WEKAClassifier)this.classifier).buildClassifier();
                }
                this.newclassifier = ((Classifier)this.getPreparedClassOption(this.baseLearnerOption)).copy();
                this.newclassifier.resetLearning();
                break;
            }
            case 0: {
                this.newClassifierReset = true;
                break;
            }
        }
        this.classifier.trainOnInstance(inst);
    }

    public double[] getVotesForInstance(Instance inst) {
        return this.classifier.getVotesForInstance(inst);
    }

    public boolean isRandomizable() {
        return true;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        ((AbstractClassifier)this.classifier).getModelDescription(out, indent);
    }

    protected Measurement[] getModelMeasurementsImpl() {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.add(new Measurement("Change detected", this.changeDetected));
        measurementList.add(new Measurement("Warning detected", this.warningDetected));
        Measurement[] modelMeasurements = ((AbstractClassifier)this.classifier).getModelMeasurements();
        if (modelMeasurements != null) {
            for (Measurement measurement : modelMeasurements) {
                measurementList.add(measurement);
            }
        }
        this.changeDetected = 0;
        this.warningDetected = 0;
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }
}

