/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

public class DebugHelper {
    public static final String DEBUG_SUFFIX = ".DEBUG";
    public static final String DEBUGLEVEL_SUFFIX = ".DEBUGLEVEL";

    public static boolean isDebugOn(Class cls) {
        return Boolean.getBoolean(cls.getName() + DEBUG_SUFFIX) || DebugHelper.getDebugLevel(cls) > 0;
    }

    public static int getDebugLevel(Class cls) {
        Integer result = 0;
        if (Integer.getInteger(cls.getName() + DEBUGLEVEL_SUFFIX) != null) {
            result = Integer.getInteger(cls.getName() + DEBUGLEVEL_SUFFIX);
        } else if (Boolean.getBoolean(cls.getName() + DEBUG_SUFFIX)) {
            result = 1;
        }
        if (result == null || result < 0) {
            result = 0;
        }
        return result;
    }

    public static void debug(Class cls, String msg) {
        String[] lines;
        String prefix = "[DEBUG] " + cls.getName() + ": ";
        for (String line : lines = msg.split("\n")) {
            System.out.println(prefix + line);
        }
    }
}

