/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Performance;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.util.Vector;

public abstract class AbstractBaselineCorrection<T extends DataContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractBaselineCorrection> {
    private static final long serialVersionUID = 2530174550698703218L;

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    public T correct(T data) {
        T result = this.doCorrect(data);
        if (result instanceof NotesHandler) {
            ((NotesHandler)result).getNotes().addProcessInformation(this);
        }
        return result;
    }

    protected T doCorrect(T data) {
        this.checkData(data);
        T result = this.processData(data);
        result.setID(data.getID() + "'");
        return result;
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract T processData(T var1);

    @Override
    public AbstractBaselineCorrection shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractBaselineCorrection shallowCopy(boolean expand) {
        return (AbstractBaselineCorrection)OptionUtils.shallowCopy(this, expand);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public static String[] getBaselineCorrections() {
        return ClassLister.getSingleton().getClassnames(AbstractBaselineCorrection.class);
    }

    public static AbstractBaselineCorrection forName(String classname, String[] options) {
        AbstractBaselineCorrection result;
        try {
            result = (AbstractBaselineCorrection)OptionUtils.forName(AbstractBaselineCorrection.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractBaselineCorrection forCommandLine(String cmdline) {
        return (AbstractBaselineCorrection)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static DataContainer correct(AbstractBaselineCorrection baseline, DataContainer data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.add(data);
        Vector<AbstractBaselineCorrection> baselineList = new Vector<AbstractBaselineCorrection>();
        baselineList.add(baseline);
        Vector<Vector<DataContainer>> corrected = AbstractBaselineCorrection.correct(baselineList, dataList);
        DataContainer result = corrected.get(0).get(0);
        return result;
    }

    public static Vector<DataContainer> correct(AbstractBaselineCorrection baseline, Vector<DataContainer> data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.addAll(data);
        Vector<AbstractBaselineCorrection> baselineList = new Vector<AbstractBaselineCorrection>();
        baselineList.add(baseline);
        Vector<Vector<DataContainer>> corrected = AbstractBaselineCorrection.correct(baselineList, dataList);
        Vector<DataContainer> result = corrected.get(0);
        return result;
    }

    public static Vector<DataContainer> correct(Vector<AbstractBaselineCorrection> baseline, DataContainer data) {
        Vector<DataContainer> dataList = new Vector<DataContainer>();
        dataList.add(data);
        Vector<AbstractBaselineCorrection> baselineList = new Vector<AbstractBaselineCorrection>();
        baselineList.addAll(baseline);
        Vector<Vector<DataContainer>> corrected = AbstractBaselineCorrection.correct(baselineList, dataList);
        Vector<DataContainer> result = new Vector<DataContainer>();
        for (int i = 0; i < corrected.size(); ++i) {
            result.add(corrected.get(i).get(0));
        }
        return result;
    }

    public static Vector<Vector<DataContainer>> correct(Vector<AbstractBaselineCorrection> baseline, Vector<DataContainer> data) {
        Vector<Vector<DataContainer>> result = new Vector<Vector<DataContainer>>();
        if (Performance.getMultiProcessingEnabled()) {
            int i;
            JobRunner runner = new JobRunner();
            JobList<BaselineCorrectionJob<DataContainer>> jobs = new JobList<BaselineCorrectionJob<DataContainer>>();
            for (int n = 0; n < baseline.size(); ++n) {
                for (i = 0; i < data.size(); ++i) {
                    AbstractBaselineCorrection threadBaseline = baseline.get(n).shallowCopy(true);
                    jobs.add(new BaselineCorrectionJob<DataContainer>(threadBaseline, data.get(i)));
                }
            }
            runner.add(jobs);
            runner.start();
            runner.stop();
            Vector<Object> subresult = null;
            for (i = 0; i < jobs.size(); ++i) {
                BaselineCorrectionJob job;
                if (i % data.size() == 0) {
                    subresult = new Vector<Object>();
                    result.add(subresult);
                }
                if ((job = (BaselineCorrectionJob)jobs.get(i)).getCorrectedData() != null) {
                    subresult.add(job.getCorrectedData());
                } else {
                    subresult.add(job.getData().getHeader());
                }
                job.cleanUp();
            }
        } else {
            for (int n = 0; n < baseline.size(); ++n) {
                Vector<DataContainer> subresult = new Vector<DataContainer>();
                result.add(subresult);
                for (int i = 0; i < data.size(); ++i) {
                    AbstractBaselineCorrection threadBaseline = baseline.get(n).shallowCopy(true);
                    subresult.add(threadBaseline.correct(data.get(i)));
                }
            }
        }
        return result;
    }

    public static class BaselineCorrectionJob<T extends DataContainer>
    extends Job {
        private static final long serialVersionUID = 5544327082749651329L;
        protected AbstractBaselineCorrection m_BaselineCorrection;
        protected T m_Data;
        protected T m_CorrectedData;

        public BaselineCorrectionJob(AbstractBaselineCorrection baseline, T data) {
            this.m_BaselineCorrection = baseline;
            this.m_Data = data;
            this.m_CorrectedData = null;
        }

        public AbstractBaselineCorrection getBaselineCorretion() {
            return this.m_BaselineCorrection;
        }

        public T getData() {
            return this.m_Data;
        }

        public T getCorrectedData() {
            return this.m_CorrectedData;
        }

        @Override
        protected String preProcessCheck() {
            if (this.m_BaselineCorrection == null) {
                return "No baseline correction scheme set!";
            }
            if (this.m_Data == null) {
                return "No data set!";
            }
            return null;
        }

        @Override
        protected void process() {
            this.m_CorrectedData = this.m_BaselineCorrection.correct(this.m_Data);
        }

        @Override
        protected String postProcessCheck() {
            if (this.m_CorrectedData == null) {
                return "Result of baseline correction scheme is null!";
            }
            return null;
        }

        @Override
        public void cleanUp() {
            super.cleanUp();
            this.m_Data = null;
            this.m_BaselineCorrection.destroy();
            this.m_BaselineCorrection = null;
            this.m_CorrectedData = null;
        }

        @Override
        protected String getAdditionalErrorInformation() {
            if (this.m_Data instanceof NotesHandler) {
                return ((NotesHandler)this.m_Data).getNotes().toString();
            }
            return "";
        }

        @Override
        public String toString() {
            String result = "data:" + this.m_Data.getID() + ", ";
            if (this.m_Data instanceof DatabaseIDHandler) {
                result = result + "db-id: " + ((DatabaseIDHandler)this.m_Data).getDatabaseID() + ", ";
            }
            result = result + "baseline correction: " + OptionUtils.getCommandLine(this.m_BaselineCorrection);
            return result;
        }
    }
}

