/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayCorrelationCoefficient<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = 8764320126807871007L;

    @Override
    public String globalInfo() {
        return "Calculates the correlation coefficient between the first array and the remaining arrays. The arrays must be numeric, of course.";
    }

    @Override
    public int getMin() {
        return 2;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size() - 1);
        for (int i = 1; i < this.size(); ++i) {
            result.setHeader(i - 1, "correlation coefficient 1-" + (i + 1));
            result.setCell(0, i - 1, StatUtils.correlationCoefficient((Number[])this.get(0), (Number[])this.get(i)));
        }
        return result;
    }
}

