/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.FieldProvider;
import adams.db.ReportProvider;
import java.util.Vector;

public abstract class ReportTable<R extends Report, F extends AbstractField>
extends AbstractIndexedTable
implements FieldProvider<F>,
ReportProvider<R> {
    private static final long serialVersionUID = -1143611181126566480L;

    public ReportTable(AbstractDatabaseConnection dbcon, String tableName) {
        super(dbcon, tableName);
    }

    protected Field createField(String name, String type) throws Exception {
        Field result;
        if (type.equals("B")) {
            result = new Field(name, DataType.BOOLEAN);
        } else if (type.equals("S")) {
            result = new Field(name, DataType.STRING);
        } else if (type.equals("N")) {
            result = new Field(name, DataType.NUMERIC);
        } else {
            throw new IllegalStateException("Unhandled type '" + type + "'!");
        }
        return result;
    }

    protected Object parse(AbstractField field, String s) {
        if (field.getDataType() == DataType.BOOLEAN) {
            return Boolean.parseBoolean(s);
        }
        if (field.getDataType() == DataType.NUMERIC) {
            return Double.parseDouble(s);
        }
        return Field.fixString(s);
    }

    @Override
    public Vector<F> getFields() {
        return this.getFields(null);
    }

    public boolean remove(Report report) {
        return this.remove(report.getDatabaseID());
    }

    @Override
    public boolean remove(int id) {
        boolean result;
        String sql = "DELETE FROM " + this.getTableName() + " " + "WHERE PARENT_ID = " + id;
        try {
            this.execute(sql);
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    public boolean store(int parent_id, R report) {
        return this.store(parent_id, report, true, false, new Field[0]);
    }

    @Override
    public boolean store(int parent_id, R report, boolean removeExisting, boolean merge, Field[] overwrite) {
        boolean canSave;
        boolean result = false;
        boolean exists = this.exists(parent_id);
        boolean bl = canSave = !exists;
        if (exists) {
            this.debug("Report already exists for: " + parent_id);
            if (removeExisting) {
                this.debug("Removing old report for: " + parent_id);
                this.remove(parent_id);
                canSave = true;
            } else if (merge) {
                this.debug("Merging with old report: " + parent_id);
                Object reportOld = this.load(parent_id);
                ((Report)reportOld).mergeWith((Report)report);
                ((Report)reportOld).setValue(new Field("Dummy report", DataType.BOOLEAN), false);
                if (overwrite != null) {
                    for (int i = 0; i < overwrite.length; ++i) {
                        try {
                            if (!((Report)report).hasValue(overwrite[i])) continue;
                            ((Report)reportOld).setValue(overwrite[i], ((Report)report).getValue(overwrite[i]));
                            continue;
                        }
                        catch (Exception e) {
                            this.getSystemErr().println("Error overwriting field '" + overwrite[i] + "' in report '" + ((Report)report).getDatabaseID() + "':");
                            this.getSystemErr().printStackTrace(e);
                        }
                    }
                }
                report = reportOld;
                canSave = true;
            } else {
                this.debug("Not saving report for: " + parent_id);
                parent_id = -1;
            }
        }
        if (canSave) {
            this.debug("Storing in DB: " + parent_id);
            result = this.doStore(parent_id, report);
        }
        return result;
    }

    protected abstract boolean doStore(int var1, R var2);
}

