/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.container.DataContainer;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.ReportProvider;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public abstract class AbstractReportDbWriter<T extends Report>
extends AbstractTransformer {
    private static final long serialVersionUID = -5253006932367969870L;
    protected boolean m_RemoveExisting;
    protected boolean m_Merge;
    protected Field[] m_OverwriteFields;
    protected boolean m_StandaloneReports;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove", "removeExisting", false);
        this.m_OptionManager.add("merge", "merge", false);
        this.m_OptionManager.add("overwrite", "overwriteFields", new Field[0]);
        this.m_OptionManager.add("standalone-reports", "standaloneReports", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    public void setRemoveExisting(boolean value) {
        this.m_RemoveExisting = value;
        this.reset();
    }

    public boolean getRemoveExisting() {
        return this.m_RemoveExisting;
    }

    public String removeExistingTipText() {
        return "If true then existing reports will be removed first completely from the database before the current one is saved.";
    }

    public void setMerge(boolean value) {
        this.m_Merge = value;
        this.reset();
    }

    public boolean getMerge() {
        return this.m_Merge;
    }

    public String mergeTipText() {
        return "If true then the information in the current report is only added to the existing one (but 'Dummy report' is always set to 'false').";
    }

    public void setOverwriteFields(Field[] value) {
        this.m_OverwriteFields = value;
        this.reset();
    }

    public Field[] getOverwriteFields() {
        return this.m_OverwriteFields;
    }

    public String overwriteFieldsTipText() {
        return "The fields to overwrite with the new data when in 'merge' mode.";
    }

    public void setStandaloneReports(boolean value) {
        this.m_StandaloneReports = value;
        this.reset();
    }

    public boolean getStandaloneReports() {
        return this.m_StandaloneReports;
    }

    public String standaloneReportsTipText() {
        return "If true then reports don't have to be associated with a data container (= 'standalone').";
    }

    @Override
    public abstract Class[] accepts();

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    protected abstract ReportProvider<T> getReportProvider();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        Report report = this.m_InputToken.getPayload() instanceof DataContainer ? ((ReportHandler)this.m_InputToken.getPayload()).getReport() : (Report)this.m_InputToken.getPayload();
        int parentID = report.getDatabaseID();
        boolean stored = false;
        if (this.m_StandaloneReports || parentID != -1) {
            ReportProvider<Report> provider = this.getReportProvider();
            stored = provider.store(parentID, report, this.m_RemoveExisting, this.m_Merge, this.m_OverwriteFields);
        } else {
            result = "No container with ID: " + parentID;
        }
        if (parentID != -1 && stored) {
            this.m_OutputToken = new Token(parentID);
        }
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

