/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import java.io.Serializable;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class CheckedTextField
extends JTextField {
    private static final long serialVersionUID = -1011286612484850433L;
    protected AbstractCheckModel m_CheckModel;

    public CheckedTextField() {
        this.initialize();
    }

    public CheckedTextField(AbstractCheckModel model) {
        this();
        this.setCheckModel(model);
    }

    public CheckedTextField(String text) {
        super(text);
        this.initialize();
    }

    public CheckedTextField(String text, AbstractCheckModel model) {
        this(text);
        this.setCheckModel(model);
    }

    public CheckedTextField(int columns) {
        super(columns);
        this.initialize();
    }

    public CheckedTextField(int columns, AbstractCheckModel model) {
        this(columns);
        this.setCheckModel(model);
    }

    public CheckedTextField(String text, int columns) {
        super(text, columns);
        this.initialize();
    }

    public CheckedTextField(String text, int columns, AbstractCheckModel model) {
        this(text, columns);
        this.setCheckModel(model);
    }

    public CheckedTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initialize();
    }

    public CheckedTextField(Document doc, String text, int columns, AbstractCheckModel model) {
        this(doc, text, columns);
        this.setCheckModel(model);
    }

    protected AbstractCheckModel getDefaultCheckModel() {
        return new StringCheckModel();
    }

    protected void initialize() {
        this.m_CheckModel = this.getDefaultCheckModel();
    }

    public void setCheckModel(AbstractCheckModel value) {
        this.m_CheckModel = value;
        if (!this.m_CheckModel.isValid(this.getText())) {
            this.setText(this.m_CheckModel.getDefaultValue());
        }
    }

    public AbstractCheckModel getCheckModel() {
        return this.m_CheckModel;
    }

    @Override
    public void setText(String t) {
        if (this.m_CheckModel != null) {
            if (this.m_CheckModel.isValid(t)) {
                super.setText(t);
            } else {
                super.setText(this.m_CheckModel.getDefaultValue());
            }
        } else {
            super.setText(t);
        }
    }

    protected void setTextUnchecked(String value) {
        super.setText(value);
    }

    protected String getTextUnchecked() {
        if (this.getDocument() != null) {
            return super.getText();
        }
        return null;
    }

    @Override
    public String getText() {
        String result;
        String current = this.getTextUnchecked();
        if (this.m_CheckModel != null && current != null) {
            if (this.m_CheckModel.isValid(current)) {
                result = current;
            } else {
                result = this.m_CheckModel.getDefaultValue();
                this.setTextUnchecked(result);
            }
        } else {
            result = current;
        }
        return result;
    }

    @Override
    public boolean isValid() {
        boolean result = true;
        String current = this.getTextUnchecked();
        if (this.m_CheckModel != null && current != null) {
            result = this.m_CheckModel.isValid(current);
        }
        return result;
    }

    public void setDefaultValue() {
        if (this.m_CheckModel != null) {
            this.setTextUnchecked(this.m_CheckModel.getDefaultValue());
        }
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result.substring(0, result.length() - 1) + ", checkModel=" + this.m_CheckModel + "]";
        return result;
    }

    public static class StringCheckModel
    extends AbstractCheckModel {
        private static final long serialVersionUID = 451762705522167701L;

        @Override
        public boolean isValid(String text) {
            return true;
        }
    }

    public static abstract class AbstractCheckModel
    implements Serializable {
        private static final long serialVersionUID = -8150917807970079198L;
        protected String m_DefaultValue;

        public AbstractCheckModel() {
            this("");
        }

        public AbstractCheckModel(String defValue) {
            this.m_DefaultValue = defValue;
        }

        public abstract boolean isValid(String var1);

        public void setDefaultValue(String value) {
            this.m_DefaultValue = value;
        }

        public String getDefaultValue() {
            return this.m_DefaultValue;
        }

        public String toString() {
            return "defValue=" + this.m_DefaultValue;
        }
    }
}

